// CheetahToMotion.js
//
// v.20130215
// tg@tres-graficos.jp
//
// it's a Tool script to export .moti file for Motion 5+.
// place this into ( ~/Library/Application Support/Cheetah3D/Scripts/Tool folder ).
//

function buildUI( tool ) {
    
    tool.addParameterFloat("fps", 30, 1, 1200, false, false);
    tool.addParameterFloat("scale factor", 1000, 1, 10000, false, false);
    tool.addParameterButton("export .motn", "export", "exportMOTN");
}

var cameraList = [];
var lightList = [];
var objectList = [];

var RAD2DEG = 180 / Math.PI;
var DEG2RAD = Math.PI / 180;

var newline = "\n";
var MOTI_headpart = '<?xml version="1.0" encoding="UTF-8"?>'+newline+
'<!DOCTYPE ozxmlscene>'+newline+
'<ozml version="4">'+newline+newline+
'<factory id="1" uuid="46c844a813d311d8a438000a95af9f7e">'+newline+
'	<description>Channel</description>'+newline+
'	<manufacturer>Apple</manufacturer>'+newline+
'	<version>1</version>'+newline+
'</factory>'+newline+newline+
'<factory id="2" uuid="65cb4dc9d4504fa281921f5f751fba06">'+newline+
'	<description>Widget</description>'+newline+
'	<manufacturer>Apple</manufacturer>'+newline+
'	<version>1</version>'+newline+
'</factory>'+newline+newline+
'<factory id="3" uuid="7d468273c013498e9806a0d7bc32fddf">'+newline+
'	<description>Project</description>'+newline+
'	<manufacturer>Apple</manufacturer>'+newline+
'	<version>1</version>'+newline+
'</factory>'+newline+newline+
'<factory id="4" uuid="de1a9415beb34e5fb0964d1528bef14a">'+newline+
'	<description>Camera</description>'+newline+
'	<manufacturer>Apple</manufacturer>'+newline+
'	<version>1</version>'+newline+
'</factory>'+newline+newline;

var MOTI_footpart = newline+'</ozml>'+newline;

// 

function exportMOTN( tool ) {
    
    var doc = tool.document();
    var animPos = doc.animPosition();
    
    var currentTake = doc.currentTake();
    
    var start = currentTake.previewFrom;
    var end = currentTake.previewTo;
    var length = end - start;// currentTake.length;
    
    var fps = tool.getParameter("fps");
    var sf = tool.getParameter("scale factor");
    
    var filepath = OS.runSavePanel("motn");
    var file = new File( filepath );
    
    var global_id = 10000;
    
    file.open(WRITE_MODE);
    
    if (!file.isOpen()) return;
    
    var currentTake = tool.document().currentTake();
    var parameterList = [
                          { start: start, fps: fps, 
                                      parameterName: 'position', type: "vec3", parameterSubCount: 3, id: 101, idSub: [1, 2, 3], 
                                      xmlParameterNameSub: ['X', 'Y', 'Z'], 
                                      valFuncs: [ function(val) { return val * sf }, function(val) { return val * sf }, function(val) { return val * sf } ],
                                      xmlParameterName: 'Position' },
                          { start: start, fps: fps,
                                      parameterName: 'rotation', type: "vec3_rot", parameterSubCount: 3, id: 109, idSub: [1, 2, 3], 
                                      xmlParameterNameSub: ['X', 'Y', 'Z'],
                                      valFuncs: [ function(val) { return val * DEG2RAD; }, function(val) { return val * DEG2RAD; }, function(val) { return val * DEG2RAD; } ],
                                      xmlParameterName: 'Rotation' },
                          { start: start, fps: fps,
                                      parameterName: 'scale', type: "vec3", parameterSubCount: 3, id: 105, idSub: [1, 2, 3], 
                                      xmlParameterNameSub: ['X', 'Y', 'Z'],
                                      valFuncs: [ function(val) { return val; }, function(val) { return val; }, function(val) { return val; } ],
                                      xmlParameterName: 'Scale' }
                                      
                         ];
    var parameterListCamera = [
                          { start: start, fps: fps, 
                                      parameterName: 'position', type: "vec3", parameterSubCount: 3, id: 101, idSub: [1, 2, 3], 
                                      xmlParameterNameSub: ['X', 'Y', 'Z'], 
                                      valFuncs: [ function(val) { return val * sf }, function(val) { return val * sf }, function(val) { return val * sf } ],
                                      xmlParameterName: 'Position' },
                          { start: start, fps: fps,
                                      parameterName: 'rotation', type: "vec3_rot", parameterSubCount: 3, id: 109, idSub: [1, 2, 3], 
                                      xmlParameterNameSub: ['X', 'Y', 'Z'],
                                      valFuncs: [ function(val) { return val * DEG2RAD; }, function(val) { return val * DEG2RAD; }, function(val) { return val * DEG2RAD; } ],
                                      xmlParameterName: 'Rotation' }
                         ];
    
    var cam = doc.activeCamera();

    if (version && parseFloat( version() ) >= 7) {
      var renderer = doc.currentRenderer();
      var resolution = renderer.getParameter("resolution");

      var resolutionX = resolution.x;
      var resolutionY = resolution.y;

    } else {
      var resolutionX = cam.getParameter("resolutionX");
      var resolutionY = cam.getParameter("resolutionY");      
    }

    var aspect = resolutionY/resolutionX;
    
    var frameCount = (parseInt(length * fps) + 1);
    
    cameraList.length = 0;
    lightList.length = 0;
    objectList.length = 0;
    storeObjects( doc.root(), tool );
    
    // new creation of component line.
    
    file.write(MOTI_headpart);
    
    file.writeln("<scene>");
    file.writeln("\t<sceneSettings>");
    file.writeln("\t\t<width>"+resolutionX+"</width>");
    file.writeln("\t\t<height>"+resolutionY+"</height>");
    file.writeln("\t\t<duration>"+frameCount+"</duration>");
    file.writeln("\t\t<frameRate>"+fps+"</frameRate>");
    file.writeln("\t\t<fieldRenderingMode>0</fieldRenderingMode>");
    file.writeln("\t\t<NTSC>0</NTSC>");
    file.writeln("\t\t<pixelAspectRatio>1</pixelAspectRatio>");
    file.writeln("\t</sceneSettings>");
    
    file.writeln("\t<currentFrame>0</currentFrame>");
    file.writeln("\t<timeRange offset=\"0\" duration=\""+frameCount+"\" />");
    file.writeln("\t<playRange offset=\"0\" duration=\""+frameCount+"\" />");
    
    file.writeln("\t<scenenode name=\"Project\" id=\""+(global_id++)+"\" factoryID=\"3\" version=\"5\">");
    file.writeln("\t\t<scenenode name=\"Widget\" id=\""+(global_id++)+"\" factoryID=\"2\" version=\"5\">");
    file.writeln("\t\t</scenenode>");
    file.writeln("\t</scenenode>\n");
    							
    var i, len, cam, obj;
    len = cameraList.length;
    for(i = 0;i < len;i++) {
        cam = cameraList[i];
        // new camera line.
        
        file.writeln("\t<scenenode name=\""+cam.getParameter("name")+"\" id=\""+(global_id++)+"\" factoryID=\"4\" version=\"5\">");
        file.writeln("\t\t<parameter name=\"Properties\" id=\"1\">");
        
        file.write( transformXml( doc, cam, parameterListCamera, currentTake, start, end, fps ) );
        
        file.writeln("\t\t</parameter>");
        
        file.writeln("\t\t<parameter name=\"Object\" id=\"2\" flags=\"8589938704\">");
        
        var param = cam.parameterWithName("fieldOfView");
        var takeNode = param.takeNodeWithName( currentTake.name );
        
        if (takeNode) {
          
          file.write( paramterXml( doc, cam, start, end, fps, "fieldOfView", "Angle Of View", 201, 45, 
                              function(val) { var h_val = val * DEG2RAD; var v_val = 2 * Math.atan( Math.tan( h_val / 2 ) / aspect ); return v_val * RAD2DEG; }  ) );
           
        } else {
          file.writeln("\t\t\t<parameter name=\"Angle Of View\" id=\"201\" default=\"45\" value=\""+(cam.getParameter("fieldOfView"))+"\" />");
        }
        
        file.writeln("\t\t</parameter>");
        file.writeln("\t</scenenode>");
    }
    
    // new null object line.
    len = objectList.length;
    for(i = 0;i < len;i++) {
        obj = objectList[i];
        
        file.writeln("\t<layer name=\""+obj.getParameter("name")+"\" id=\""+(global_id++)+"\">");
        file.writeln("\t\t<parameter name=\"Properties\" id=\"1\" flags=\"8589938704\">");
        
        file.write( transformXml( doc, obj, parameterList, currentTake, start, end, fps ) );
        
        file.writeln("\t\t</parameter>");
        file.writeln("\t\t<parameter name=\"Object\" id=\"2\">");
        file.writeln("\t\t\t<parameter name=\"Type\" id=\"307\" default=\"0\" value=\"1\" />");
        file.writeln("\t\t</parameter>");
        file.writeln("\t</layer>");
    }
        
    file.writeln("</scene>");
    
    file.write(MOTI_footpart);
    
    file.close();
    
    doc.setAnimPosition( animPos );
    
}

function paramterXml( doc, obj, start, end, fps, parameterName, parameterLabel, parameterId, parameterDefault, func ) {
  var str = '';
  
  //var curve = takeNode.fCurveAtIndex(0);
  var keyCount = parseInt( (end - start) * fps );
  var keySpan = 1 / fps;
  
  
  str += "\t\t\t<parameter name=\""+parameterLabel+"\" id=\""+parameterId+"\" defualt=\""+parameterDefault+"\">\n";
  str += "\t\t\t\t<curve type=\"1\">\n";
  str += "\t\t\t\t\t<numberOfKeypoints>"+keyCount+"</numberOfKeypoints>\n";
  
  for (var i = 0;i <= keyCount;i++) {
    doc.setAnimPosition( start + (keySpan * i) );
    //var value= curve.valueAtTime( start + (i*keySpan) );
    var value = obj.getParameter( parameterName );
    
    str += "\t\t\t\t\t\t\t<keypoint interpolation=\"1\" flags=\"32\">\n";
    str += "\t\t\t\t\t\t\t\t<time>"+i+"</time>\n";
    str += "\t\t\t\t\t\t\t\t<value>"+func( value )+"</value>\n";
    str += "\t\t\t\t\t\t\t</keypoint>\n";
  }

  str += "\t\t\t\t</curve>\n";
  str += "\t\t\t</parameter>\n";
  
  return str;
}

function transformXml( doc, obj, parameterList, currentTake, start, end, fps ) {

  var str = "\t\t\t<parameter name=\"Transform\" id=\"100\">\n";
  
  for(var j in parameterList ) {
    var info = parameterList[j];
    var parameterName = info.parameterName;
    var param = obj.parameterWithName( parameterName );
    
    str += "\t\t\t\t<parameter name=\""+info.xmlParameterName+"\" id=\""+info.id+"\">\n";
    
    var takeNode = param.takeNodeWithName( currentTake.name );
    
    if (true) { // takeNode) {
      
      var parameterCount;
      var keyCount = parseInt( ( end - start) * fps );
      var keySpan = 1 / fps;
      
      switch ( info.type ) {
        case 'vec3':
        case 'vec3_rot':
          parameterCount = 3;
          break;
        default:
          parameterCount = 1;    
      }
      
      for (var k = 0;k < parameterCount;k++) {
        var tip = null;
        //var curve = takeNode.fCurveAtIndex( k );
        
        str += "\t\t\t\t\t<parameter name=\""+info.xmlParameterNameSub[k]+"\" id=\""+info.idSub[k]+"\" value=\"0\">\n";
        str += "\t\t\t\t\t\t<curve type=\"1\">\n";
        str += "\t\t\t\t\t\t\t<numberOfKeypoints>"+keyCount+"</numberOfKeypoints>\n";
        
        for (var l = 0;l <= keyCount;l++) {
          doc.setAnimPosition( start + (keySpan * l) );
          //var val = curve.valueAtTime( start + (l*keySpan) );
          var vec = obj.getParameter( info.parameterName );
          var val;
          
          if (info.type == 'vec3_rot') {
            
            /*
            var rot_h = takeNode.fCurveAtIndex( 0 );
            var rot_p = takeNode.fCurveAtIndex( 1 );
            var rot_b = takeNode.fCurveAtIndex( 2 );
            
            var hpb = new Vec3D( rot_h.valueAtTime( start + (l*keySpan) ), rot_p.valueAtTime( start + (l*keySpan) ), rot_b.valueAtTime( start + (l*keySpan) ) );
             */
            var hpb = vec;
            
            if (tip) {
              var xyz = hpb.convertEuler( ROT_HPB, ROT_XYZ );
            } else {
              var xyz = hpb.convertEuler( ROT_HPB, ROT_XYZ, tip );
            }
            
            switch( k ) {
              case 0:
                val = hpb.y;
                break;
              case 1:
                val = hpb.x;
                break;
              case 2:
                val = hpb.z;
                break;
            }
            
            tip = xyz;
          } else {
            
            switch( k ) {
              case 0:
                val = vec.x;
                break;
              case 1:
                val = vec.y;
                break;
              case 2:
                val = vec.z;
                break;
              case 3:
                val = vec.w;
                break;
            }
          }
          
          str += "\t\t\t\t\t\t\t<keypoint interpolation=\"1\" flags=\"32\">\n";
          str += "\t\t\t\t\t\t\t\t<time>"+l+"</time>\n";
          str += "\t\t\t\t\t\t\t\t<value>"+info.valFuncs[ j ](val)+"</value>\n";
          str += "\t\t\t\t\t\t\t</keypoint>\n";
        }
        str += "\t\t\t\t\t\t</curve>\n";
        str += "\t\t\t\t\t</parameter>\n";
      }
      
    } else {
      
      var vec = obj.getParameter( parameterName );
      
      if (info.type == 'vec3_rot') {
        var val = [ vec.y, vec.x, vec.z ];
      } else if (info.type == 'vec3') {
        var val = [ vec.x, vec.y, vec.z ];
      } else {
        var val = [ vec ];
      }
      
      for (var k = 0;k < info.parameterSubCount;k++) {
        str += "\t\t\t\t\t<parameter name=\""+info.xmlParameterNameSub[k]+"\" id=\""+info.idSub[k]+"\" value=\""+info.valFuncs[ 0 ]( val[k] )+"\" />\n";
      }
      
    }
    
    str += "\t\t\t\t</parameter>\n";
  }
  str += "\t\t\t</parameter>\n";
  
  return str;
}

function rotationOfObj( obj, rot ) {
    
    rot = rot.add( obj.getParameter("rotation") );
    
    if (obj.owner()) {
        return rotationOfObj( obj.owner(), rot );
    } else {
        return rot;
    }
}

function eulerOutOfRotationMatrix( mat, mode ) {
    var vec = new Vec3D();
    
    // XYZ
    vec.y = Math.asin( Math.max( -1.0, Math.min( 1.0, - mat.m20 ) ) );
    if (Math.abs( Math.cos( vec.y ) ) > 0.0001) {
        vec.x = Math.atan2( mat.m21, mat.m22 );
        vec.z = Math.atan2( mat.m10, mat.m00 );
    } else {
        vec.x = 0;
        vec.z = Math.atan2( - mat.m01, mat.m11 );
    }
    
    vec.x *= RAD2DEG;
    vec.y *= RAD2DEG;
    vec.z *= RAD2DEG;
    
    return vec;
}

function storeObjects( obj, tool ) {
	var len = obj.childCount();
	for (var i = 0;i < len;i++) {
		var child = obj.childAtIndex( i );
		//
		var childType = child.type();
		var modeTag = tagForType( child, 103 );
		
		if (modeTag && modeTag.getParameter("renderActive")) { // only render on
			if (child.family() == NGONFAMILY || child.type() == FOLDER) {
				objectList.push(child);
			} else if (child.family() == LIGHTFAMILY) {
			  lightList.push(child);
			}
		} else if (childType == CAMERA) {
      cameraList.push(child);
    }
        
		if ( childType == SYMMETRY || childType == BOOLEAN || childType == CHAIN || childType == EXTRUDE ||
							childType == LATHE || childType == POLYPLANE || childType == SWEEP ) { // stop seek if obj is creator.
			//
		} else {
			storeObjects( child, tool );
		}
	}
}

// getting tag for type
function tagForType(obj, tagType) {
	var tagCount = obj.tagCount();
	var resultTag = false;
	for (var i = 0;i < tagCount;i++) {
		var tag = obj.tagAtIndex(i);
		if (tag.type() == tagType && tag.getParameter("tagOn")) {
			resultTag = tag;
		}
	}
	return resultTag;
}

function tagsForType(obj, tagType) {
	var tagCount = obj.tagCount();
	var resultTags = [];
	for (var i = 0;i < tagCount;i++) {
		var tag = obj.tagAtIndex(i);
		if (tag.type() == tagType && tag.getParameter("tagOn")) {
			resultTags.push(tag);
		}
	}
	return resultTags;
}

function tagForScriptName(obj, scriptName) {
	var tagCount = obj.tagCount();
	var resultTag = false;
	for (var i = 0;i < tagCount;i++) {
		var tag = obj.tagAtIndex(i);
		if (tag.getParameter("scriptName") == scriptName && tag.getParameter("tagOn")) {
			resultTag = tag;
		}
	}
	return resultTag;
}
