// CheetahToAE.js
//
// v.20111122
// tg@tres-graficos.jp
//
// it's a Tool script to export .jsx file for creating new composit of AfterEffects.
// place this into ( ~/Library/Application Support/Cheetah3D/scripts/Tool folder ).
//
// all camera and object ( as null object ) will be exported. new composit sizes are set by active camera properties.
// after exporting, new .jsx file will be craeted. by executing this script with AfterEffect, you can create new composite.

function buildUI( tool ) {
    
    tool.addParameterInt("fps", 30, 1, 1200, false, false);
    tool.addParameterFloat("scale factor", 100, 1, 10000, false, false);
    tool.addParameterButton("export .jxs", "export", "exportJSX");
    
}

var cameraList = [];
var objectList = [];

var RAD2DEG = 180 / Math.PI;

function resolutionForCam( doc, cam ) {
    if (version && parseFloat( version() ) >= 7) {
      var renderer = doc.currentRenderer();
      var resolution = renderer.getParameter("resolution");

      var resolutionX = resolution.x;
      var resolutionY = resolution.y;
    } else {
        var resolutionX = cam.getParameter("resolutionX");
        var resolutionY = cam.getParameter("resolutionY");        
    }

    return { x: resolutionX, y: resolutionY };
}

function exportJSX( tool ) {
    
    var doc = tool.document();
    
    var fps = tool.getParameter("fps");

    if (version && parseFloat( version() ) >= 7) {

        var take = doc.currentTake();

        var start = take.previewFrom;
        var end = take.previewTo;
    } else {

        var start = doc.animationStart(); //tool.getParameter("time to start");
        var end = doc.animationEnd(); //tool.getParameter("time to end");
    }

    var sf = tool.getParameter("scale factor");
    var current = start;
    
    var filepath = OS.runSavePanel("jsx");
    var file = new File( filepath );
    
    file.open(WRITE_MODE);
    
    if (!file.isOpen()) return;
    
    var doc = tool.document();
    var cam = doc.activeCamera();

    var resolution = resolutionForCam( doc, cam );
    
    var aspect = resolution.x/resolution.y;
    var duration = end - start;
    
    cameraList.length = 0;
    objectList.length = 0;
    storeObjects( doc.root(), tool );
    
    var compName = file.lastPathComponent().replace('.'+file.extension(), '');
    
    // new creation of component line.
    file.writeln("\n//");
    file.writeln('var newComp = app.project.items.addComp("'+compName+'", '+
                    resolution.x +', '+
                    resolution.y +', '+
                    aspect+', '+
                    duration+', '+
                    fps+');');
    file.writeln('newComp.pixelAspect = 1.0;');
    
    var i, len, cam, obj;
    len = cameraList.length;
    for(i = 0;i < len;i++) {
        cam = cameraList[i];
        // new camera line.
        resolution = resolutionForCam( doc, cam );
        
        file.writeln("\n//");
        file.writeln('writeLn("Creating camera: '+cam.getParameter("name")+'")');
        file.writeln('var cam'+i+' = newComp.layers.addCamera("'+cam.getParameter("name")+'",[0,0]);');
        //file.writeln('cam'+i+'.property("rotationX").setValue( 180 );');
        //file.writeln('cam'+i+'.property("rotationY").setValue( 180 );');
        file.writeln('cam'+i+'.property("rotationZ").setValue( 180 );');
    }
    
    // new null object line.
    len = objectList.length;
    for(i = 0;i < len;i++) {
        obj = objectList[i];
        
        file.writeln("\n//");
        file.writeln('writeLn("Creating null: '+obj.getParameter("name")+'")');
        file.writeln('var obj'+i+' = newComp.layers.addNull();');
        file.writeln('obj'+i+'.threeDLayer = true;');
        file.writeln('obj'+i+'.source.name = "'+obj.getParameter("name")+'";');
        //file.writeln('obj'+i+'.property("rotationX").setValue( 180 );');
        file.writeln('obj'+i+'.property("rotationY").setValue( 180 );');
        file.writeln('obj'+i+'.property("rotationZ").setValue( 180 );');
    }
    
    var frame_index = 1;
    
    while ( current <= end ) {
        doc.setAnimPosition( current );
        
        file.writeln("\n// frame:"+frame_index++);
        
        // wirte camera animation
        activeCam = doc.activeCamera();
        
        len = cameraList.length;
        for (i = 0;i < len;i++) {
            cam = cameraList[i];
            resolution = resolutionForCam( doc, cam );

            aspect = resolution.x/resolution.y;
            
            var mat = cam.obj2WorldMatrix();
            
            var pos = new Vec3D(mat.m03, mat.m13, mat.m23);
            pos = pos.multiply( sf );
            //var rot = eulerOutOfRotationMatrix( mat, 0 );
            rot_or = rotationOfObj( cam, new Vec3D() );
            var rot = new Vec3D( rot_or.y, rot_or.x, rot_or.z );
            
            var distance = cam.getParameter("distance");
            var dofTag = tagForType( cam, DOFTAG );
            if (dofTag) {
                distance = dofTag.getParameter("focalDistance");
            }
            var interest = mat.multiply( new Vec3D( 0, 0, - distance ) );
            interest = interest.multiply( sf );
            var zoom = ( resolution.x / 2) / ( Math.tan( cam.getParameter("fieldOfView") / 2 * (Math.PI/180) ) ) / aspect;
            
            file.writeln('cam'+i+'.property("position").setValueAtTime('+current+', ['+pos.x.toFixed(4)+', '+pos.y.toFixed(4)+', '+pos.z.toFixed(4)+']);');
            file.writeln('cam'+i+'.property("pointOfInterest").setValueAtTime('+current+', ['+interest.x.toFixed(4)+', '+interest.y.toFixed(4)+', '+interest.z.toFixed(4)+']);');
            
            file.writeln('cam'+i+'.property("zoom").setValueAtTime('+current+', '+zoom.toFixed(4)+');');
        }
        
        // write objects animation
        len = objectList.length;
        for (i = 0;i < len;i++) {
            obj = objectList[i];
            
            mat = obj.obj2WorldMatrix();
            
            pos = new Vec3D(mat.m03, mat.m13, mat.m23);
            pos = pos.multiply( sf );
            //rot = eulerOutOfRotationMatrix( mat, 1 );
            rot_or = rotationOfObj( obj, new Vec3D() );
            rot = new Vec3D( rot_or.y, rot_or.x, rot_or.z );
            
            file.writeln('obj'+i+'.property("position").setValueAtTime('+current+', ['+pos.x.toFixed(4)+', '+pos.y.toFixed(4)+', '+pos.z.toFixed(4)+']);');

            file.writeln('obj'+i+'.property("orientation").setValueAtTime('+current+', [0, '+rot.y.toFixed(4)+', '+rot.z.toFixed(4)+']);');
            file.writeln('obj'+i+'.property("rotationX").setValueAtTime('+current+', '+rot.x.toFixed(4)+');');
        }
        
        current += 1/fps;
        
    }
    
    file.close();
    
    doc.setAnimPosition( start );
}

function rotationOfObj( obj, rot ) {
    
    rot = rot.add( obj.getParameter("rotation") );
    
    if (obj.owner()) {
        return rotationOfObj( obj.owner(), rot );
    } else {
        return rot;
    }
}

function eulerOutOfRotationMatrix( mat, mode ) {
    var vec = new Vec3D();
    
    // XYZ
    vec.y = Math.asin( Math.max( -1.0, Math.min( 1.0, - mat.m20 ) ) );
    if (Math.abs( Math.cos( vec.y ) ) > 0.0001) {
        vec.x = Math.atan2( mat.m21, mat.m22 );
        vec.z = Math.atan2( mat.m10, mat.m00 );
    } else {
        vec.x = 0;
        vec.z = Math.atan2( - mat.m01, mat.m11 );
    }
    
    
    vec.x *= RAD2DEG;
    vec.y *= RAD2DEG;
    vec.z *= RAD2DEG;
    
    return vec;
}

function storeObjects( obj, tool ) {
	var len = obj.childCount();
	for (var i = 0;i < len;i++) {
		var child = obj.childAtIndex( i );
		//
		var childType = child.type();
		var modeTag = tagForType( child, 103 );
		if (modeTag && modeTag.getParameter("renderActive")) { // only render on
			if (child.family() == NGONFAMILY || child.family() == LIGHTFAMILY || child.type() == FOLDER) {
				objectList.push(child);
			}
		} else if (childType == CAMERA) {
            cameraList.push(child);
        }
        
		if ( childType == SYMMETRY || childType == BOOLEAN || childType == CHAIN || childType == EXTRUDE ||
							childType == LATHE || childType == POLYPLANE || childType == SWEEP ) { // stop seek if obj is creator.
			//
		} else {
			storeObjects( child, tool );
		}
	}
}

// getting tag for type
function tagForType(obj, tagType) {
	var tagCount = obj.tagCount();
	var resultTag = false;
	for (var i = 0;i < tagCount;i++) {
		var tag = obj.tagAtIndex(i);
		if (tag.type() == tagType && tag.getParameter("tagOn")) {
			resultTag = tag;
		}
	}
	return resultTag;
}

function tagsForType(obj, tagType) {
	var tagCount = obj.tagCount();
	var resultTags = [];
	for (var i = 0;i < tagCount;i++) {
		var tag = obj.tagAtIndex(i);
		if (tag.type() == tagType && tag.getParameter("tagOn")) {
			resultTags.push(tag);
		}
	}
	return resultTags;
}

function tagForScriptName(obj, scriptName) {
	var tagCount = obj.tagCount();
	var resultTag = false;
	for (var i = 0;i < tagCount;i++) {
		var tag = obj.tagAtIndex(i);
		if (tag.getParameter("scriptName") == scriptName && tag.getParameter("tagOn")) {
			resultTag = tag;
		}
	}
	return resultTag;
}
