//
// cHair.js (Normal Checker.js)
//
//  v.110129 - beta? - this is still yet test code!!.
//  required version : Cheetah3D v5.5+
//
//  (c) 2006-2010 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 2010-11-11 separated from Hair.js
// 2010-11-11 add 'hair count' parameter
// 2010-11-16 change default paramters
// 2010-12-25 fixed rotation bug.
// 2011-01-29 fixed uv factor bug.
// 2011-02-03 remove "update" button.
// 2012-09-13 direciton target added.
//
// Usage: Place this into scripts/Polygonobj folder. restart Cheetah3D, then select this script from Tools -> Scritp -> Polygon Script
//

var randoms = new Array;
var randoms_pos = new Array;
var randoms_length = 2000;

var randoms_hair = new Array;

var radian_p = 180/Math.PI;

var hCount = 0;

var splHolder;
var splList = new Array;
var hairCache = new Array;

var uvType = 0;

function buildUI(obj){
	obj.setParameter("name","Hair");
	
	//obj.addParameterBool("use modified child",1,0,1,true,true);
	
	obj.addParameterSeparator("Hair Settings");
	
	obj.addParameterInt("hair count",10,1,1000000,true,true);
	obj.addParameterInt("segments",1,1,50,true,true);

	obj.addParameterBool('auto segment',1,0,1,true,true);
	obj.addParameterFloat('approx. angle',15,1,90,true,true);
	
	obj.addParameterFloat("hair min width",0.01,0,100,true,true);
	obj.addParameterFloat("hair width",0.01,0,100,true,true);
	obj.addParameterSelector("use width factor",["none", "random", "UV1.u", "UV1.v", "UV2.u", "UV2.v"],true,true);
	
	obj.addParameterFloat("hair min length",0.1,0,1000,true,true);
	obj.addParameterFloat("hair length",0.1,0,1000,true,true);
	obj.addParameterSelector("use length factor",["none", "random", "UV1.u", "UV1.v", "UV2.u", "UV2.v"],true,true);
	
	obj.addParameterFloat("thinness",0.1,0,10,true,true);
	
	obj.addParameterBool("triangle end",0,0,1,true,true);
	obj.addParameterBool("only polygon selection",0,0,1,true,true);
	obj.addParameterInt("polygon selection",0,0,15,true,true);
	
	obj.addParameterSeparator("Direction Settings");
	
  	obj.addParameterLink("direction target", true);
  
	obj.addParameterSelector("implant angle",['x','z','mix1','mix2','mix3','random180','random360'],true,true);
	obj.addParameterFloat("curly min x",0,-1440,1440,true,true);
	obj.addParameterFloat("curly min y",0,-1440,1440,true,true);
	obj.addParameterFloat("curly min z",0,-1440,1440,true,true);
	obj.addParameterFloat("curly x",0,-1440,1440,true,true);
	obj.addParameterFloat("curly y",0,-1440,1440,true,true);
	obj.addParameterFloat("curly z",0,-1440,1440,true,true);
	obj.addParameterSelector("use UV curl",["none","UV1.u","UV1.v","UV2.u","UV2.v"],true,true);
	
	obj.addParameterFloat("direction x",0,-100,100,true,true);
	obj.addParameterFloat("direction y",0,-100,100,true,true);
	obj.addParameterFloat("direction z",0,-100,100,true,true);
	obj.addParameterSelector("use UV direction",["none","UV1.u","UV1.v","UV2.u","UV2.v"],true,true);
	
	obj.addParameterFloat("random a",0,-100,100,true,true);
	obj.addParameterFloat("random b",0,-100,100,true,true);
	
	obj.addParameterBool("as creator",0,0,1,true,true);
	
	obj.addParameterSeparator("Smooth");
	obj.addParameterSelector("smooth",["flat","phong","constraint"],true,true);
	obj.addParameterFloat("smooth angle", 45.0, 5.0, 90.0, true, true);

    obj.addParameterSeparator("random");
    obj.addParameterInt("random seed", 123456, 0, 999999, true, true);

	obj.setParameter("smooth",2);
	
	//obj.setCreatorObj(true);
	
}

function addHair(core, vert, rot, width_h, length, thinness, segments, randB, randB_h, gravV, gravity, curlV, uv, implantAngle, triend) {
	var transMat = new Mat4D(TRANSLATE, vert.x, vert.y, vert.z);
	var rotMat = new Mat4D(ROTATE_HPB, rot.x, rot.y, rot.z);
	var impMat = new Mat4D(ROTATE_HPB, implantAngle, 0, 0);
	
	var baseMat = transMat.multiply(rotMat.multiply(impMat));
	
	// add first part.
	core.addVertex(false, baseMat.multiply(new Vec3D( width_h, 0, 0)));
	core.addVertex(false, baseMat.multiply(new Vec3D(-width_h, 0, 0)));
	
	var len_f = length/segments;
	
	for (i = 1;i <= segments;i++) {
		var segFac = (i)*(1/segments); // ?
		var segVFac = (i*2)/(segments*segments);
		var nextCurlV = curlV.multiply(segFac);
		var curlMat = new Mat4D(ROTATE, nextCurlV.x, nextCurlV.y, nextCurlV.z);
		if (gravity) {
			var gravMat = new Mat4D(TRANSLATE, gravV.x*segVFac, gravV.y*segVFac, gravV.z*segVFac);
			var vecMat = gravMat.multiply(baseMat.multiply(curlMat));
		} else {
			var vecMat = baseMat.multiply(curlMat);
		}
		//var thin = 1 - (1-thinness)/segments*i; //? - linear
		var rand_cache = randoms[(i+hCount) % 100];
		//var cache = hairCache[i-1];
		//print(thin);
		if (splList.length > 0) {
			var cache = hairCache[i-1];
		} else {
			var thin = 1 - (1-thinness)/segments*(i);
			var cache = [ new Vec3D(width_h*thin, (i)*len_f, 0), new Vec3D(-width_h*thin, (i)*len_f, 0) ];
		}
		if (triend && i == segments) {
			if (randB != 0) {
				var v1 = vecMat.multiply(cache[0].add(new Vec3D( rand_cache[0]*randB-randB_h, rand_cache[1]*randB-randB_h, rand_cache[2]*randB-randB_h)));
			} else {
				var v1 = vecMat.multiply(cache[0]);
			}
			addSeg(core, v1, '', 1/segments, i, uv, true);
		} else {
			if (randB != 0) {
				var v1 = vecMat.multiply(cache[0].add(new Vec3D( rand_cache[0]*randB-randB_h, rand_cache[1]*randB-randB_h, rand_cache[2]*randB-randB_h)));
				var v2 = vecMat.multiply(cache[1].add(new Vec3D( rand_cache[0]*randB-randB_h, rand_cache[1]*randB-randB_h, rand_cache[2]*randB-randB_h)));
			} else {
				var v1 = vecMat.multiply(cache[0]);
				var v2 = vecMat.multiply(cache[1]);
			}
			addSeg(core, v1, v2, 1/segments, i, uv, false);
		}
	}
}

function addSeg(core, vec1, vec2, segments_f, iter, uv, triend) {
	var p1 = core.addVertex(false, vec1);
	if (!triend) var p2 = core.addVertex(false, vec2);
	
	if (triend) {
		if (1) {
			var uv1 = new Vec4D(uv.x, uv.y, 0.5, segments_f*iter);
			var uv2 = new Vec4D(uv.x, uv.y, 0, segments_f*(iter-1));
			var uv3 = new Vec4D(uv.x, uv.y, 1, segments_f*(iter-1));
			var pi = core.addIndexPolygon(3, [p1, (p1-1), (p1-2)]); //, [uv1, uv3, uv2]);
			core.setUVCoord( pi, 0, uv1 );
			core.setUVCoord( pi, 1, uv3 );
			core.setUVCoord( pi, 2, uv2 );
		}
	} else {
		if (1) {
			var uv1 = new Vec4D(uv.x, uv.y, 0, segments_f*iter);
			var uv2 = new Vec4D(uv.x, uv.y, 0, segments_f*(iter-1));
			var uv3 = new Vec4D(uv.x, uv.y, 1, segments_f*(iter-1));
			var uv4 = new Vec4D(uv.x, uv.y, 1, segments_f*iter);
			var pi = core.addIndexPolygon(4, [p1, p2, (p1-1), (p1-2)]); //, [uv1, uv4, uv3, uv2]);
			core.setUVCoord( pi, 0, uv1 );
			core.setUVCoord( pi, 1, uv4 );
			core.setUVCoord( pi, 2, uv3 );
			core.setUVCoord( pi, 3, uv2 );
		}
	}
}

function pointFromPercentage(percent, mat) { // these spline stuff from Todd's Loft.js
	if (percent < 0 && percent > 1) return new Vec3D(0,0,0);
	var i; var hi = splHolder.length - 1; var lo = 0;
	var d = percent;
	while (hi - lo > 1) {
		i = Math.floor((hi+lo)/2);
		if (percent <= splList[i]) {
			hi = i;
			continue;
		}
		if (percent > splList[i]) {
			lo = i;
		}
	}
	i = hi;
	
	var p1 = splHolder[i-1];
	var p2 = splHolder[i];
	//
	d = (d - splList[i-1])/(splList[i] - splList[i-1]);
	p1 = p1.multiply(1-d).add(p2.multiply(d));
	return mat.multiply(p1);
}

function cacheSplineLength() {
	var l = splHolder.length;
	var i;
	var accum = 0;
	splList[0] = 0;
	for (i = 0;i < l - 1;i++) {
		var p = splHolder[i+1].sub(splHolder[i]);
		accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
		splList[i+1] = accum;
	}
	for (i = 0;i < l;i++) {
		splList[i] = splList[i] / accum;
	}
}

var random_seed = null;

function buildObject(obj){
	var core = obj.core();
	var i,j;
	
	var random_update = false;	
	if (random_seed != obj.getParameter("random seed")) {
		random_update = true;
		random_seed = obj.getParameter("random seed");
	  	Math.seedrandom( random_seed );	
	}

	var width_min_h = obj.getParameter("hair min width") / 2;
	var width_h = obj.getParameter("hair width") / 2;
	var uv_width = parseInt(obj.getParameter("use width factor"));
	
	var length_min = obj.getParameter("hair min length");
	var length = obj.getParameter("hair length");
	var uv_len = parseInt(obj.getParameter("use length factor"));
	
	var triend = obj.getParameter("triangle end");
	var polysel = obj.getParameter("only polygon selection");
	var polyselNum = obj.getParameter("polygon selection");
	
	var implantAType = parseInt(obj.getParameter("implant angle"));
	var curlMinX = obj.getParameter("curly min x");
	var curlMinY = obj.getParameter("curly min y");
	var curlMinZ = obj.getParameter("curly min z");
	var curlX = obj.getParameter("curly x");
	var curlY = obj.getParameter("curly y");
	var curlZ = obj.getParameter("curly z");
	var uv_curl = parseInt(obj.getParameter("use UV curl"));
	
	var auto_seg = obj.getParameter('auto segment');
	var auto_seg_angle = obj.getParameter("approx. angle");
	var segments = obj.getParameter("segments");
	var mod = true; //obj.getParameter("use modified child");	
	
  var gravObj = obj.getParameter("direction target");
  
  if (!gravObj) {
  	var gravX = obj.getParameter("direction x");
  	var gravY = obj.getParameter("direction y");
  	var gravZ = obj.getParameter("direction z");
  } else {
    var gravMat = gravObj.obj2WorldMatrix();
    var grav = gravMat.multiply( new Vec3D(0, 0, 0) );
    
    var gravX = grav.x;
    var gravY = grav.y;
    var gravZ = grav.z;
    
    var dirRot = gravObj.getParameter("rotation");
    
    curlMinX += dirRot.x;
    curlMinY += dirRot.y;
    curlMinZ += dirRot.z;
    
  }
  
	var uv_grav = parseInt(obj.getParameter("use UV direction"));
	
	var count = obj.getParameter("hair count");
	var thinness = obj.getParameter("thinness");
	
	var randA = obj.getParameter("random a");
	var randB = obj.getParameter("random b");
	
	var gravity = true;
	if (gravX == 0 && gravY == 0 && gravZ == 0 && randA == 0) gravity = false;
	var gravGV = new Vec3D(gravX, gravY, gravZ);
	var curlV = new Vec3D(curlMinX, curlMinY, curlMinZ);
	
	var widthV = new Vec3D(0, 0, width_h);
	var length_v = length_min + length;
	var width_hv = width_min_h + width_h;
	
	if (obj.childCount() > 0) {
		var guide = obj.childAtIndex(0);
		
    if (gravObj) {
      var gGravMatrix = guide.obj2WorldMatrix();
      var gGrav = gGravMatrix.multiply( new Vec3D(0, 0, 0) );
      
      gravGV = gravGV.sub( gGrav );
    }
		obj.setParameter("normalType",obj.getParameter("smooth"),false);
		obj.setParameter("normalAngle",obj.getParameter("smooth angle"),false);
		
		if (obj.getParameter("as creator")) obj.setCreatorObj( true );
		else obj.setCreatorObj( false );
		
		splList.length = 0;
		if (obj.childCount() > 1) {
			var spl = obj.childAtIndex(1);
			if (spl.family() == SPLINEFAMILY) {
				var splCore = spl.modCore();
				var splMat = spl.objMatrix();
				
				if (splCore.pathCount() > 0) {
					splCore = splCore.cache(0);
					if (splCore != null) {
						splHolder = splCore;
						cacheSplineLength();
					}
				}
			}
		}
		if (guide.family() == NGONFAMILY) {
			// bench
			var st1 = new Date().getTime();
			//print('--- cHair.js ---');
			
			// getting base polyCore
			if (mod) var guideCore = guide.modCore();
			else var guideCore = guide.core();
			
			var guidePolyCount = guideCore.polygonCount();
			var guideMat = guide.objMatrix();
			var guideRot = guide.getParameter("rotation");
			var guideNormMat = new Mat4D( ROTATE_HPB, guideRot.x, guideRot.y, guideRot.z );
			var polysel_store = guide.getParameter("activePolySelection");
			
			// count check
			if (guidePolyCount < 1) {
				print( 'guide mesh has no face.' );
				return;
			}
			//
			if ( 3 * randoms_length * guidePolyCount < count) {
				count = 3 * randoms_length * guidePolyCount;
				obj.setParameter("hair count", count);
			}
			
			if (random_update || randoms.length < randoms_length) {
				//print("calc randoms");
				for (i = 0;i < randoms_length;i++) {
					randoms[i] = [Math.random(), Math.random(), Math.random()];
				}
			}
			if (random_update || randoms_pos.length < randoms_length) {
				for (i = randoms_pos.length;i < count;i++) {
					randoms_pos[i] = [ Math.random(), Math.random(), Math.random(), Math.random()];
				}
			}
			// create hairCache
			hairCache.length = 0;
			var len_f = length/segments;
			for (i = 0;i < segments;i++) {
				var thin = 1 - (1-thinness)/segments*(i+1); // Linear
				hairCache[i] = new Array;
				if (splList.length > 0) {
					if (triend && i == segments - 1) {
						hairCache[i][0] = pointFromPercentage(1/segments * i, splMat);
					} else {
						hairCache[i][0] = new Vec3D( width_h*thin, 0, 0).add(pointFromPercentage(1/segments * i, splMat));
						hairCache[i][1] = new Vec3D(-width_h*thin, 0, 0).add(pointFromPercentage(1/segments * i, splMat));
					}
				}
			}
			switch (implantAType) {
				case 0:
					var getImplantAngle = function(i, j) { return 180; };
					break;
				case 1:
					var getImplantAngle = function(i, j) { return -90; };
					break;
				case 2:
					var getImplantAngle = function(i, j) { return (i % 2) * 90; };
					break;
				case 3:
					var getImplantAngle = function(i, j) { return (i % 5) * 45; };
					break;
				case 4:
					var getImplantAngle = function(i, j) { return (i % 9) * 45; };
					break;
				case 5:
					var getImplantAngle = function(i, j) { return randoms[(i % randoms_length)][(j % 3)] * 180; };
					break;
				case 6:
					var getImplantAngle = function(i, j) { return randoms[(i % randoms_length)][(j % 3)] * 360; };
					break;
			}
			
			if (polysel) {
				guideCore.setActivePolygonSelection(parseInt(polyselNum));
				
				var selCheck = true;
				for (i = 0;i < guidePolyCount;i++) {
					if (guideCore.polygonSelection(i)) {
						selCheck = false;
					}
				}
				if (selCheck) {
					//print('no polygon selected');
					return;
				}
				
				var r_len = randoms_hair.length;
				for (i = 0;i < r_len;i++) {
					while ( ! guideCore.polygonSelection( Math.floor( randoms_hair[ i ] * guidePolyCount ) ) ) {
						randoms_hair[ i ] = Math.random(); 
					}
				}
				if (random_update || randoms_hair.length < count) {
					for (i = randoms_hair.length;i < count;i++) {
						randoms_hair[i] = Math.random();
						while ( ! guideCore.polygonSelection( Math.floor( randoms_hair[ i ] * guidePolyCount ) ) ) {
							randoms_hair[ i ] = Math.random(); 
						}
					}
				}
			} else {
				if (random_update || randoms_hair.length < count) {
					for (i = randoms_hair.length;i < count;i++) {
						randoms_hair[i] = Math.random();
					}
				}
			}
			
			var randA_h = randA / 2;
			var randB_h = randB / 2;
			var curlX_h = curlX / 2;
			var curlY_h = curlY / 2;
			var curlZ_h = curlZ / 2;
			
			hCount = 0;
			
			var hairCreated = true;
			var hi = 0;
			while( hCount < count ) {
			
				i = Math.floor( randoms_hair[ hCount ] * guidePolyCount );
				if (!polysel || guideCore.polygonSelection(i)) {
					var gSize = guideCore.polygonSize(i);
					if (gSize > 100) break; //
					var implantAngle = 0;
					/*
					if ((i/guidePolyCount*100) % 25 == 0) {
						print('processing ' + (i/guidePolyCount*100) + ' %.');
					}
					*/
					//
					
					implantAngle = getImplantAngle(hCount, hi);
					
					// for other random factor rot/dir
					var rand_i = ( hi) % randoms_length;
					var rand1 = randoms[rand_i][0];
					var rand2 = randoms[rand_i][1];
					var rand3 = randoms[rand_i][2];
					//var v, h;
					
					var rnd = randoms_pos[ hCount % randoms_length ];
					var tnum = Math.floor( rnd[ hCount % 3 ] * (gSize - 2) );
					var tindices = guideCore.triangle( i, tnum );
					
					var pos_total = rnd[0] + rnd[1] + rnd[2];
					
					var vert = guideCore.vertex(guideCore.vertexIndex(i, tindices[0])).multiply( rnd[0] / pos_total ).add(
							   guideCore.vertex(guideCore.vertexIndex(i, tindices[1])).multiply( rnd[1] / pos_total )).add(
							   guideCore.vertex(guideCore.vertexIndex(i, tindices[2])).multiply( rnd[2] / pos_total ));
					var uv = guideCore.uvCoord(i, tindices[0]).multiply( rnd[0] / pos_total ).add(
							 guideCore.uvCoord(i, tindices[1]).multiply( rnd[1] / pos_total )).add(
							 guideCore.uvCoord(i, tindices[2]).multiply( rnd[2] / pos_total ));
					
					var rand_k = i % randoms_length;
					if (gravity) {
						var gravV = gravGV.add(new Vec3D(rand1*randA-randA_h,rand2*randA-randA_h,rand3*randA-randA_h));
						if (uv_grav == 1) gravV = gravV.multiply( uv.x );
						if (uv_grav == 2) gravV = gravV.multiply( uv.y );
						if (uv_grav == 3) gravV = gravV.multiply( uv.z );
						if (uv_grav == 4) gravV = gravV.multiply( uv.w );
					}
					
					var normal = guideNormMat.multiply( guideCore.normal(i) );
					// calc rotation
					var theta = Math.acos(normal.y)*radian_p;
					var phi = Math.atan2(normal.x, normal.z)*radian_p;
					var rot = new Vec3D(phi, theta, 0);
					//
					curlRanV = curlV.add(new Vec3D(rand1*curlX-curlX_h, rand2*curlY-curlY_h, rand3*curlZ-curlZ_h));
					
					if (uv_curl == 1) curlRanV = curlRanV.multiply( uv.x );
					else if (uv_curl == 2) curlRanV = curlRanV.multiply( uv.y );
					else if (uv_curl == 3) curlRanV = curlRanV.multiply( uv.z );
					else if (uv_curl == 4) curlRanV = curlRanV.multiply( uv.w );
					
					if (auto_seg) {
						var rot_max = Math.max(Math.max(Math.abs(curlRanV.x), Math.abs(curlRanV.y)), Math.abs(curlRanV.z));
						segments = Math.floor(rot_max / auto_seg_angle) + 1;
					}
					
					vert = guideMat.multiply(vert);
					
					switch(uv_len) {
						case 0:
							; break;
						case 1:
							length_v = length_min + length * rand1; break;
						case 2:
							length_v = length_min + length * uv.x;  break;
						case 3:
							length_v = length_min + length * uv.y;  break;
						case 4:
							length_v = length_min + length * uv.z;  break;
						case 5:
							length_v = length_min + length * uv.w;  break;
					}
					
					switch(uv_width) {
						case 0:
							; break;
						case 1:
							width_hv = width_min_h + width_h * rand1; break;
						case 2:
							width_hv = width_min_h + width_h * uv.x;  break;
						case 3:
							width_hv = width_min_h + width_h * uv.y;  break;
						case 4:
							width_hv = width_min_h + width_h * uv.z;  break;
						case 5:
							width_hv = width_min_h + width_h * uv.w;  break;
					}
					addHair(core, vert, rot, width_hv, length_v, thinness, segments, randB, randB_h, gravV, gravity, curlRanV, uv, implantAngle, triend);
					hCount++;
				}
				hi++;
			}
			if (polysel) guideCore.setActivePolygonSelection(parseInt(polysel_store));
			
			// bench
			/*
			var st2 = new Date().getTime();
			var st3 = st2 - st1;
			print("bench:"+(st3/1000).toFixed(2)+" sec(s), count:"+hCount);
			*/
		}
	}
}

// seeded random

/**
 * All code is in an anonymous closure to keep the global namespace clean.
 */
(function (
    global, pool, math, width, chunks, digits, module, define, rngname) {

//
// The following constants are related to IEEE 754 limits.
//
var startdenom = math.pow(width, chunks),
    significance = math.pow(2, digits),
    overflow = significance * 2,
    mask = width - 1,

//
// seedrandom()
// This is the seedrandom function described above.
//
impl = math['seed' + rngname] = function(seed, options, callback) {
  var key = [];
  options = (options == true) ? { entropy: true } : (options || {});

  // Flatten the seed string or build one from local entropy if needed.
  var shortseed = mixkey(flatten(
    options.entropy ? [seed, tostring(pool)] :
    (seed == null) ? autoseed() : seed, 3), key);

  // Use the seed to initialize an ARC4 generator.
  var arc4 = new ARC4(key);

  // Mix the randomness into accumulated entropy.
  mixkey(tostring(arc4.S), pool);

  // Calling convention: what to return as a function of prng, seed, is_math.
  return (options.pass || callback ||
      // If called as a method of Math (Math.seedrandom()), mutate Math.random
      // because that is how seedrandom.js has worked since v1.0.  Otherwise,
      // it is a newer calling convention, so return the prng directly.
      function(prng, seed, is_math_call) {
        if (is_math_call) { math[rngname] = prng; return seed; }
        else return prng;
      })(

  // This function returns a random double in [0, 1) that contains
  // randomness in every bit of the mantissa of the IEEE 754 value.
  function() {
    var n = arc4.g(chunks),             // Start with a numerator n < 2 ^ 48
        d = startdenom,                 //   and denominator d = 2 ^ 48.
        x = 0;                          //   and no 'extra last byte'.
    while (n < significance) {          // Fill up all significant digits by
      n = (n + x) * width;              //   shifting numerator and
      d *= width;                       //   denominator and generating a
      x = arc4.g(1);                    //   new least-significant-byte.
    }
    while (n >= overflow) {             // To avoid rounding up, before adding
      n /= 2;                           //   last byte, shift everything
      d /= 2;                           //   right using integer math until
      x >>>= 1;                         //   we have exactly the desired bits.
    }
    return (n + x) / d;                 // Form the number within [0, 1).
  }, shortseed, 'global' in options ? options.global : (this == math));
};

//
// ARC4
//
// An ARC4 implementation.  The constructor takes a key in the form of
// an array of at most (width) integers that should be 0 <= x < (width).
//
// The g(count) method returns a pseudorandom integer that concatenates
// the next (count) outputs from ARC4.  Its return value is a number x
// that is in the range 0 <= x < (width ^ count).
//
/** @constructor */
function ARC4(key) {
  var t, keylen = key.length,
      me = this, i = 0, j = me.i = me.j = 0, s = me.S = [];

  // The empty key [] is treated as [0].
  if (!keylen) { key = [keylen++]; }

  // Set up S using the standard key scheduling algorithm.
  while (i < width) {
    s[i] = i++;
  }
  for (i = 0; i < width; i++) {
    s[i] = s[j = mask & (j + key[i % keylen] + (t = s[i]))];
    s[j] = t;
  }

  // The "g" method returns the next (count) outputs as one number.
  (me.g = function(count) {
    // Using instance members instead of closure state nearly doubles speed.
    var t, r = 0,
        i = me.i, j = me.j, s = me.S;
    while (count--) {
      t = s[i = mask & (i + 1)];
      r = r * width + s[mask & ((s[i] = s[j = mask & (j + t)]) + (s[j] = t))];
    }
    me.i = i; me.j = j;
    return r;
    // For robust unpredictability discard an initial batch of values.
    // See http://www.rsa.com/rsalabs/node.asp?id=2009
  })(width);
}

//
// flatten()
// Converts an object tree to nested arrays of strings.
//
function flatten(obj, depth) {
  var result = [], typ = (typeof obj), prop;
  if (depth && typ == 'object') {
    for (prop in obj) {
      try { result.push(flatten(obj[prop], depth - 1)); } catch (e) {}
    }
  }
  return (result.length ? result : typ == 'string' ? obj : obj + '\0');
}

//
// mixkey()
// Mixes a string seed into a key that is an array of integers, and
// returns a shortened string seed that is equivalent to the result key.
//
function mixkey(seed, key) {
  var stringseed = seed + '', smear, j = 0;
  while (j < stringseed.length) {
    key[mask & j] =
      mask & ((smear ^= key[mask & j] * 19) + stringseed.charCodeAt(j++));
  }
  return tostring(key);
}

//
// autoseed()
// Returns an object for autoseeding, using window.crypto if available.
//
/** @param {Uint8Array|Navigator=} seed */
function autoseed(seed) {
  try {
    global.crypto.getRandomValues(seed = new Uint8Array(width));
    return tostring(seed);
  } catch (e) {
    return [+new Date, global, (seed = global.navigator) && seed.plugins,
            global.screen, tostring(pool)];
  }
}

//
// tostring()
// Converts an array of charcodes to a string
//
function tostring(a) {
  return String.fromCharCode.apply(0, a);
}

//
// When seedrandom.js is loaded, we immediately mix a few bits
// from the built-in RNG into the entropy pool.  Because we do
// not want to intefere with determinstic PRNG state later,
// seedrandom will not call math.random on its own again after
// initialization.
//
mixkey(math[rngname](), pool);

//
// Nodejs and AMD support: export the implemenation as a module using
// either convention.
//
if (module && module.exports) {
  module.exports = impl;
} else if (define && define.amd) {
  define(function() { return impl; });
}

// End anonymous scope, and pass initial values.
})(
  this,   // global window object
  [],     // pool: entropy pool starts empty
  Math,   // math: package containing random, pow, and seedrandom
  256,    // width: each RC4 output is 0 <= x < 256
  6,      // chunks: at least six RC4 outputs for each double
  52,     // digits: there are 52 significant digits in a double
  (typeof module) == 'object' && module,    // present in node.js
  (typeof define) == 'function' && define,  // present with an AMD loader
  'random'// rngname: name for Math.random and Math.seedrandom
);


