#!/usr/bin/php
<?php
// php script to render lxs files.

// help
if ($argc == 1 || in_array($argv[1], array('--help', '-help', '-h', '-?'))) {
?>
::Usage::
LuxCheetah_helper.php [-s start_frame_number] [-e end_frame_number] lxs_file_directory
<?
	exit;
}

$console_path = "/Applications/LuxRender/luxconsole";
$work_dir = $argv[ count($argv) - 1];

if (is_dir($work_dir)) {
	$work_dir = preg_replace("/(.*)\/$/", "$1", $work_dir);
	$tmp_list = scandir( $work_dir, 1 );
	$file_list = array();
	
	foreach($tmp_list as $tmp) {
		if (preg_match("/\.lxs$/", $tmp)) {
			array_unshift($file_list, $tmp);
		}
	}
	
	$s_frame = -1;
	$e_frame = -1;
	for ($i = 0;$i < count($argv);$i++) {
		if ($argv[$i] == '-s') {
			$s_frame = intval($argv[$i+1]);
		} else if ($argv[$i] == '-e') {
			$e_frame = intval($argv[$i+1]);
		}
	}
	
	foreach($file_list as $file) {
		if (preg_match("/([0-9]+)\.lxs/", $file, $num_match)) {
			$c_frame = intval($num_match[1]);
			if (($s_frame === -1 || $c_frame >= $s_frame) && ($e_frame === -1 || $c_frame <= $e_frame)) {
				system($console_path . " " . $work_dir . "/" . $file);
			}
		} else {
			system($console_path . " " . $work_dir . "/" . $file);
		}
	}
} else {
	echo $work_dir . ' is not directory.';
	exit;
}
