//
//  MarchingCube.h (dataset.h)
//
//  Marching Cubes
//
//  Created by Steve Challis on 25/01/2010.
//  Copyright 2010 All rights reserved.
//    from http://github.com/schallis/marchingcubes
//
//	Modified by Hiroto Tsubaki

#import <Cocoa/Cocoa.h>
#import <Accelerate/Accelerate.h>

#define LERP(a,l,h)	((l)+(((h)-(l))*(a)))

typedef struct {
	double points[3][3]; // tripoint, xyz
} Triangle;

@interface MarchingCube : NSObject {

	float * scalarData;
	  int   dimensions[3];
	
    Triangle * triangles;
    
	int num_triangles;
	
    int num_allocated;
    int num_elements;
	
    float maxValue;
    float minValue;
	
	float isoValue;
	
	double min_x;
	double min_y;
	double min_z;
	
	double max_x;
	double max_y;
	double max_z;
	
	double gridSize;
	
	double tri_min_x;
	double tri_min_y;
	double tri_min_z;
	
	double tri_max_x;
	double tri_max_y;
	double tri_max_z;
	
	bool _useGCD;
	
}

@property (readwrite) Triangle *triangles;

@property (readwrite) int num_triangles;
@property (readwrite) int num_allocated;
@property (readwrite) int num_elements;
@property (readwrite) float isoValue;
@property (readwrite) float minValue;
@property (readwrite) float maxValue;

@property (readwrite) double min_x;
@property (readwrite) double min_y;
@property (readwrite) double min_z;
@property (readwrite) double max_x;
@property (readwrite) double max_y;
@property (readwrite) double max_z;
@property (readwrite) double gridSize;

@property (readwrite) double tri_min_x;
@property (readwrite) double tri_min_y;
@property (readwrite) double tri_min_z;
@property (readwrite) double tri_max_x;
@property (readwrite) double tri_max_y;
@property (readwrite) double tri_max_z;

- (  id  )initWithBytes:(char *)data gridSizeX:(int)sizex sizeY:(int)sizey sizeZ:(int)sizez blurIter:(int)blurIter useGCD:(bool)useGCD;
- ( void )clearData;
- ( float)isovalueFromUnitIsovalue:(float)value ;
- ( void )recalculateWithIsovalue:(float)value; // recalculate triangles
- (  int )addTriangle:(Triangle)item;

@end
