//
// Hair.js (Normal Checker.js)
//
//  v.090106 - beta? - this is still yet test code!!.
//  required version : Cheetah3D v3.5+
//
//  (c) 2006-2009 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 2007-01-30 first test.
// 2007-01-31 added some options.
// 2007-02-01 fixed width calculation bug.
// 2007-02-02 change width and curly calculaitons.
// 2007-02-03 change calculation. add uv type option.
// 2007-02-13 added 'curly coordinate', fixed 'face to cam' option bug. :)
// 2007-02-17 added poly-selection option.
// 2007-12-15 some code changed. fixed shear bug. new parameters added, and some parameters deleted.
// 2007-12-19 optimized. new parameters added. spline option.
// 2008-07-23 addes UV2 set option.
// 2009-01-06 fixed segments bug. ;p
//
// Usage: Place this into scripts/Polygonobj folder. restart Cheetah3D, then select this script from Tools -> Scritp -> Polygon Script
//

var randoms = new Array;
var randoms_sub = new Array;
var randoms_length = 400;
var radian_p = 180/Math.PI;
var hCount = 0;
var splHolder;
var splList = new Array;
var hairCache = new Array;

function buildUI(obj){
	obj.setParameter("name","Hair");
	
	obj.addParameterSelector("implant type",["faces","points","faces and points"],true,true);
	obj.addParameterSelector("uv type",["hair","base object"],true,true);
	obj.addParameterBool("modified child",0,0,1,true,true);
	
	obj.addParameterSeparator("Hair Settings");
	
	//obj.addParameterInt("count",1,1,10000,true,true);
	obj.addParameterInt("segments",1,1,50,true,true);
	
	obj.addParameterFloat("hair width",0.05,0,10,true,true);
	obj.addParameterBool("UV2 u width",0,0,1,true,true);
	
	obj.addParameterFloat("hair length",1.0,0,100,true,true);
	obj.addParameterBool("UV2 v length",0,0,1,true,true);
	
	obj.addParameterFloat("thinness",0.8,0,10,true,true);
	
	obj.addParameterBool("triangle end",0,0,1,true,true);
	obj.addParameterBool("only polygon selection",0,0,1,true,true);
	obj.addParameterInt("polygon selection",0,0,15,true,true);
	
	obj.addParameterSeparator("Direction Settings");
	
	obj.addParameterSelector("implant angle",['x','z','mix1','mix2','mix3','random180','random360'],true,true);
	obj.addParameterFloat("curly min x",0,-1440,1440,true,true);
	obj.addParameterFloat("curly min y",0,-1440,1440,true,true);
	obj.addParameterFloat("curly min z",0,-1440,1440,true,true);
	obj.addParameterFloat("curly x",0,-1440,1440,true,true);
	obj.addParameterFloat("curly y",0,-1440,1440,true,true);
	obj.addParameterFloat("curly z",0,-1440,1440,true,true);
	obj.addParameterBool("UV2 u curl",0,0,1,true,true);
	
	obj.addParameterFloat("direction x",0,-100,100,true,true);
	obj.addParameterFloat("direction y",0,-100,100,true,true);
	obj.addParameterFloat("direction z",0,-100,100,true,true);
	obj.addParameterBool("UV2 v direction",0,0,1,true,true);
	
	obj.addParameterFloat("random a",0,-100,100,true,true);
	obj.addParameterFloat("random b",0,-100,100,true,true);
	
	obj.addParameterButton("update","Update","objectUpdate");
	
	obj.addParameterSeparator("Smooth");
	obj.addParameterSelector("smooth",["flat","phong","constraint"],true,true);
	obj.addParameterFloat("smooth angle", 45.0, 5.0, 90.0, true, true);
	
	obj.setParameter("smooth",2);
	
	//obj.setCreatorObj(true);
}

function objectUpdate(obj) {
	obj.update();
}

function addHair(core, vert, rot, width_h, length, thinness, segments, randB, randB_h, gravV, gravity, curlV, uv, implantAngle, triend) {
	var transMat = new Mat4D(TRANSLATE, vert.x, vert.y, vert.z);
	var rotMat = new Mat4D(ROTATE_HPB, rot.x, rot.y, rot.z);
	var impMat = new Mat4D(ROTATE_HPB, implantAngle, 0, 0);
	
	var baseMat = transMat.multiply(rotMat.multiply(impMat));
	
	// add first part.
	core.addVertex(false, baseMat.multiply(new Vec3D( width_h, 0, 0)));
	core.addVertex(false, baseMat.multiply(new Vec3D(-width_h, 0, 0)));
	
	var len_f = length/segments;
	
	for (i = 1;i <= segments;i++) {
		var segFac = (i)*(1/segments); // ?
		var segVFac = (i*2)/(segments*segments);
		var nextCurlV = curlV.multiply(segFac);
		var curlMat = new Mat4D(ROTATE, nextCurlV.x, nextCurlV.y, nextCurlV.z);
		if (gravity) {
			var gravMat = new Mat4D(TRANSLATE, gravV.x*segVFac, gravV.y*segVFac, gravV.z*segVFac);
			var vecMat = gravMat.multiply(baseMat.multiply(curlMat));
		} else {
			var vecMat = baseMat.multiply(curlMat);
		}
		//var thin = 1 - (1-thinness)/segments*i; //? - linear
		var rand_cache = randoms[(i+hCount) % 100];
		//var cache = hairCache[i-1];
		//print(thin);
		if (splList.length > 0) {
			var cache = hairCache[i-1];
		} else {
			var thin = 1 - (1-thinness)/segments*(i);
			var cache = [ new Vec3D(width_h*thin, (i)*len_f, 0), new Vec3D(-width_h*thin, (i)*len_f, 0) ];
		}
		if (triend && i == segments) {
			if (randB != 0) {
				var v1 = vecMat.multiply(cache[0].add(new Vec3D( rand_cache[0]*randB-randB_h, rand_cache[1]*randB-randB_h, rand_cache[2]*randB-randB_h)));
			} else {
				var v1 = vecMat.multiply(cache[0]);
			}
			addSeg(core, v1, '', 1/segments, i, uv, true);
		} else {
			if (randB != 0) {
				var v1 = vecMat.multiply(cache[0].add(new Vec3D( rand_cache[0]*randB-randB_h, rand_cache[1]*randB-randB_h, rand_cache[2]*randB-randB_h)));
				var v2 = vecMat.multiply(cache[1].add(new Vec3D( rand_cache[0]*randB-randB_h, rand_cache[1]*randB-randB_h, rand_cache[2]*randB-randB_h)));
			} else {
				var v1 = vecMat.multiply(cache[0]);
				var v2 = vecMat.multiply(cache[1]);
			}
			addSeg(core, v1, v2, 1/segments, i, uv, false);
		}
	}
}

function addSeg(core, vec1, vec2, segments_f, iter, uv, triend) {
	var p1 = core.addVertex(false, vec1);
	if (!triend) var p2 = core.addVertex(false, vec2);
	
	if (triend) {
		if (!uv) {
			var uv1 = new Vec2D(0.5, segments_f*iter);
			var uv2 = new Vec2D(0, segments_f*(iter-1));
			var uv3 = new Vec2D(1, segments_f*(iter-1));
			//var uv4 = new Vec2D(1, segments_f*iter);
			core.addIndexPolygon(3, [p1, (p1-1), (p1-2)], [uv1, uv3, uv2]);
		} else {
			var uv = new Vec2D(uv.x, uv.y);
			core.addIndexPolygon(3, [p1, (p1-1), (p1-2)], [uv, uv, uv]);
		}
	} else {
		if (!uv) {
			var uv1 = new Vec2D(0, segments_f*iter);
			var uv2 = new Vec2D(0, segments_f*(iter-1));
			var uv3 = new Vec2D(1, segments_f*(iter-1));
			var uv4 = new Vec2D(1, segments_f*iter);
			core.addIndexPolygon(4, [p1, p2, (p1-1), (p1-2)], [uv1, uv4, uv3, uv2]);
		} else {
			var uv = new Vec2D(uv.x, uv.y);
			core.addIndexPolygon(4, [p1, p2, (p1-1), (p1-2)], [uv, uv, uv, uv]);
		}
	}
}

function pointFromPercentage(percent, mat) { // these spline stuff from Todd's Loft.js
	if (percent < 0 && percent > 1) return new Vec3D(0,0,0);
	var i; var hi = splHolder.length - 1; var lo = 0;
	var d = percent;
	while (hi - lo > 1) {
		i = Math.floor((hi+lo)/2);
		if (percent <= splList[i]) {
			hi = i;
			continue;
		}
		if (percent > splList[i]) {
			lo = i;
		}
	}
	i = hi;
	
	var p1 = splHolder[i-1];
	var p2 = splHolder[i];
	//
	d = (d - splList[i-1])/(splList[i] - splList[i-1]);
	p1 = p1.multiply(1-d).add(p2.multiply(d));
	return mat.multiply(p1);
}

function cacheSplineLength() {
	var l = splHolder.length;
	var i;
	var accum = 0;
	splList[0] = 0;
	for (i = 0;i < l - 1;i++) {
		var p = splHolder[i+1].sub(splHolder[i]);
		accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
		splList[i+1] = accum;
	}
	for (i = 0;i < l;i++) {
		splList[i] = splList[i] / accum;
	}
}

function buildObject(obj){
	var core = obj.core();
	var i,j;
	var hType =obj.getParameter("implant type");
	
	var width_h = obj.getParameter("hair width") / 2;
	var uv_width = obj.getParameter("UV2 u width");
	
	var length = obj.getParameter("hair length");
	var uv_len = obj.getParameter("UV2 v length");
	
	var triend = obj.getParameter("triangle end");
	var polysel = obj.getParameter("only polygon selection");
	var polyselNum = obj.getParameter("polygon selection");
	
	var implantAType = parseInt(obj.getParameter("implant angle"));
	var curlMinX = obj.getParameter("curly min x");
	var curlMinY = obj.getParameter("curly min y");
	var curlMinZ = obj.getParameter("curly min z");
	var curlX = obj.getParameter("curly x");
	var curlY = obj.getParameter("curly y");
	var curlZ = obj.getParameter("curly z");
	var uv_curl = obj.getParameter("UV2 u curl");
	
	var segments = obj.getParameter("segments");
	var uvType = parseInt(obj.getParameter("uv type"));
	var mod = obj.getParameter("modified child");	
	
	var gravX = obj.getParameter("direction x");
	var gravY = obj.getParameter("direction y");
	var gravZ = obj.getParameter("direction z");
	var uv_grav = obj.getParameter("UV2 v direction");

	//var count = obj.getParameter("count");
	var thinness = obj.getParameter("thinness");
	
	var randA = obj.getParameter("random a");
	var randB = obj.getParameter("random b");
	
	var gravity = true;
	if (gravX == 0 && gravY == 0 && gravZ == 0 && randA == 0) gravity = false;
	var gravGV = new Vec3D(gravX, gravY, gravZ);
	var curlV = new Vec3D(curlMinX, curlMinY, curlMinZ);
	
	var widthV = new Vec3D(0, 0, width_h);
	
	if (obj.childCount() > 0) {
		var guide = obj.childAtIndex(0);
		
		obj.setParameter("normalType",obj.getParameter("smooth"),false);
		obj.setParameter("normalAngle",obj.getParameter("smooth angle"),false);
		
		splList.length = 0;
		if (obj.childCount() > 1) {
			var spl = obj.childAtIndex(1);
			if (spl.family() == SPLINEFAMILY) {
				var splCore = spl.modCore();
				var splMat = spl.objMatrix();
				
				if (splCore.pathCount() > 0) {
					splCore = splCore.cache(0);
					if (splCore != null) {
						splHolder = splCore;
						cacheSplineLength();
					}
				}
			}
		}
		if (guide.family() == NGONFAMILY) {
			// bench
			//var st1 = new Date().getTime();
			
			// getting base polyCore
			if (mod) var guideCore = guide.modCore();
			else var guideCore = guide.core();
			
			var guidePolyCount = guideCore.polygonCount();
			var guideMat = guide.objMatrix();
			var polysel_store = guide.getParameter("activePolySelection");
			
			if (randoms.length < randoms_length) {
				//print("calc randoms");
				for (i = 0;i < randoms_length;i++) {
					randoms[i] = [Math.random(), Math.random(), Math.random()];
				}
			}
			if (randoms_sub.length < 100) {
				//print("calc randoms_sub");
				for (i = 0;i < 100;i++) { // 100 corner poly max;
					randoms_sub[i] = Math.random();
				}
			}
			// create hairCache
			hairCache.length = 0;
			var len_f = length/segments;
			for (i = 0;i < segments;i++) {
				var thin = 1 - (1-thinness)/segments*(i+1); // Linear
				hairCache[i] = new Array;
				if (splList.length > 0) {
					if (triend && i == segments - 1) {
						hairCache[i][0] = pointFromPercentage(1/segments * i, splMat);
					} else {
						hairCache[i][0] = new Vec3D( width_h*thin, 0, 0).add(pointFromPercentage(1/segments * i, splMat));
						hairCache[i][1] = new Vec3D(-width_h*thin, 0, 0).add(pointFromPercentage(1/segments * i, splMat));
					}
				} else { // don't use cache anymore in case with normal path!
					/*
					if (triend && i == segments - 1) 
						hairCache[i][0] = new Vec3D(0, (i+1)*len_f, 0);
					else {
						hairCache[i][0] = new Vec3D( width_h*thin, (i+1)*len_f, 0);
						hairCache[i][1] = new Vec3D(-width_h*thin, (i+1)*len_f, 0);
					}
					*/
					;
				}
			}
			switch (implantAType) {
				case 0:
					var getImplantAngle = function(index) {
						return 180;
					};
					break;
				case 1:
					var getImplantAngle = function(index) {
						return -90;
					};
					break;
				case 2:
					var getImplantAngle = function(index) {
						return (index % 2) * 90;
					};
					break;
				case 3:
					var getImplantAngle = function(index) {
						return (index % 5) * 45;
					};
					break;
				case 4:
					var getImplantAngle = function(index) {
						return (index % 9) * 45;
					};
					break;
				case 5:
					var getImplantAngle = function(index) {
						return randoms[(index % randoms_length)][0] * 180;
					};
					break;
				case 6:
					var getImplantAngle = function(index) {
						return randoms[(index % randoms_length)][0] * 360;
					};
					break;
			}
			
			if (polysel) guideCore.setActivePolygonSelection(parseInt(polyselNum));
			
			var randA_h = randA / 2;
			var randB_h = randB / 2;
			var curlX_h = curlX / 2;
			var curlY_h = curlY / 2;
			var curlZ_h = curlZ / 2;
			
			hCount = 0;
			for (i = 0;i < guidePolyCount;i++) {
				if (!polysel || guideCore.polygonSelection(i)) {
					var gSize = guideCore.polygonSize(i);
					if (gSize > 100) break; //
					var implantAngle = 0;
					/*
					if ((i/guidePolyCount*100) % 25 == 0) {
						print('processing ' + (i/guidePolyCount*100) + ' %.');
					}
					*/
					if (hType != 0) { // points
						for (j = 0;j < gSize;j++) {
							var rand = randoms_sub[j];
							var rand_i = i % randoms_length;
							var rand1 = (randoms[rand_i][0] + rand)/2;
							var rand2 = (randoms[rand_i][1] + rand)/2;
							var rand3 = (randoms[rand_i][2] + rand)/2;
							implantAngle = getImplantAngle(i+j);
							
							var vert = guideCore.vertex(guideCore.vertexIndex(i,j));
							var normal = guideCore.normal(i,j);
							var uv = guideCore.uvCoord(i,j);
							
							if (gravity) var gravV = gravGV.add(new Vec3D(rand1*randA-randA_h,rand2*randA-randA_h,rand3*randA-randA_h));
							if (gravity && uv_grav) gravV = gravV.multiply(uv.w);
							
							// calc rotation
							var theta = Math.acos(normal.y)*radian_p;
							var phi = Math.atan2(normal.x, normal.z)*radian_p;
							var rot = new Vec3D(phi, theta, 0);
							//
							curlRanV = curlV.add(new Vec3D(rand1*curlX-curlX_h, rand2*curlY-curlY_h, rand3*curlZ-curlZ_h));
							if (uv_curl) curlRanV = curlRanV.multiply(uv.z);
							
							vert = guideMat.multiply(vert);
							
							var length_v = (uv_len)? length * uv.z : length;
							var width_hv = (uv_width)? width_h * uv.w : width_h;
							if (uvType == 0) uv = false;
							addHair(core, vert, rot, width_hv, length_v, thinness, segments, randB, randB_h, gravV, gravity, curlRanV, uv, implantAngle, triend);
							hCount++;
						}
					}
					implantAngle = getImplantAngle(i);
					if (hType != 1) { // faces
						var rand_i = i % randoms_length;
						var rand1 = randoms[rand_i][0];
						var rand2 = randoms[rand_i][1];
						var rand3 = randoms[rand_i][2];
						//var v, h;
						
						var vert = guideCore.vertex(guideCore.vertexIndex(i,0));
						var uv = guideCore.uvCoord(i,0);
						
						for (j = 1;j < gSize;j++) {
							vert = vert.add(guideCore.vertex(guideCore.vertexIndex(i,j)));
							var add_uv = guideCore.uvCoord(i,j);
							uv = uv.add(add_uv);
						}
						var gSize_f = 1/gSize;
						vert = vert.multiply(gSize_f);
						uv = uv.multiply(gSize_f);
						
						var rand_k = i % randoms_length;
						if (gravity) var gravV = gravGV.add(new Vec3D(rand1*randA-randA_h,rand2*randA-randA_h,rand3*randA-randA_h));
						if (gravity && uv_grav) gravV = gravV.multiply(uv.w);
						
						var normal = guideCore.normal(i);
						// calc rotation
						var theta = Math.acos(normal.y)*radian_p;
						var phi = Math.atan2(normal.x, normal.z)*radian_p;
						var rot = new Vec3D(phi, theta, 0);
						//
						curlRanV = curlV.add(new Vec3D(rand1*curlX-curlX_h, rand2*curlY-curlY_h, rand3*curlZ-curlZ_h));
						if (uv_curl) curlRanV = curlRanV.multiply(uv.z);
						
						vert = guideMat.multiply(vert);
						
						var length_v = (uv_len)? length * uv.z : length;
						var width_hv = (uv_width)? width_h * uv.w : width_h;
						if (uvType == 0) uv = false;
						addHair(core, vert, rot, width_hv, length_v, thinness, segments, randB, randB_h, gravV, gravity, curlRanV, uv, implantAngle, triend);
						hCount++;
					}
				}
			}
			if (polysel) guideCore.setActivePolygonSelection(parseInt(polysel_store));
			
			// bench
			/*
			var st2 = new Date().getTime();
			var st3 = st2 - st1;
			print("bench:"+st3+", count:"+hCount);
			*/
		}
	}
}
