// C3D_VERSINO_REQUIREMENT 7.0.0
//
// Cracker.js
//
// 2016-12-01: initial release.
//
// Hiroto Tsubaki tg@tres-graficos.jp
//

var random_seed = null;
var crackTypes = ["random", "regular", "point random", "point weight"];

function buildUI( tool ) {
    tool.addParameterSeparator("Cracker");
    
    tool.addParameterInt("pieces", 10, 2, 4096, false, false);

    tool.addParameterSelector("crack type", crackTypes, false, false);
    
    tool.addParameterFloat("crack size var.", 0, 0, 1, false, false);
    tool.addParameterFloat("crack angle var.", 0, -1, 1, false, false);

    tool.addParameterVec3D("crack point", new Vec3D(0, 0, 0), new Vec3D(-1000, -1000, -1000), new Vec3D(1000, 1000, 1000), false, false);
    tool.addParameterFloat("crack weight", 0, 0, 100, false, false);
    tool.addParameterFloat("crack weight curve", 0, 0, 100, false, false);
    tool.addParameterFloat("crack min size", 0.1, 0, 100, false, false);

    tool.addParameterBool("copy material tags", 1, 0, 1, false, false);
    tool.addParameterBool("keep original", 1, 0, 1, false, false);
    tool.addParameterBool("burn pivot", 0, 0, 1, false, false);
    //tool.addParameterBool("make group", 1, 0, 1, false, false);

    tool.addParameterButton("crack", "apply", "crack");

    tool.addParameterSeparator("random");
    tool.addParameterInt("random seed", 123456, 0, 999999, true, true);
}

var cutIndices = [];
var cutVertices = [];
var cutObj = null;
var cutObjCore = null;
var cutMod = null;

function cutPolygonObject( doc, obj, pos, rot, mat ) {

    var list = [];
    var len = 0;

    if (cutObj === null) {
        cutObj = doc.addObject(POLYGONOBJ);
        cutObjCore = cutObj.core();

        len = cutVertices.length;
        for (k = 0;k < len;k++) cutObjCore.addVertex( false, cutVertices[k] );
        len = cutIndices.length;
        for (k = 0;k < len;k++) cutObjCore.addIndexPolygon( 4, cutIndices[k] );
    }

    if (cutMod === null) {
        cutMod = doc.addObject(BOOLEANMOD);
    }

    var trMat = new Mat4D(TRANSLATE, pos.x, pos.y, pos.z);
    var rotMat = new Mat4D(ROTATE_HPB, rot.x, rot.y, rot.z);
    var cutMat = mat.multiply( trMat.multiply( rotMat )  );

    for (k = 0;k < 8;k++) cutObjCore.setVertex( k, cutMat.multiply(cutVertices[k]) );
    cutObj.update();
    
    //
    doc.root().addChildAtIndex(cutObj, doc.root().childCount()-1);

    obj.addChildAtIndex(cutMod, 0); 
    cutMod.addChildAtIndex(cutObj, 0);

    cutMod.setParameter("operation", 1);

    var op1 = doc.addObject(POLYGONOBJ);
    doc.root().addChildAtIndex(op1, doc.root().childCount()-1);

    if (copyPolygons(obj.modCore(), op1.core())) {
        op1.update();
        list.push(op1);
    } else {
        op1.owner().removeChild(op1);
    }

    cutMod.setParameter("operation", 2);

    var op2 = doc.addObject(POLYGONOBJ);
    doc.root().addChildAtIndex(op2, doc.root().childCount()-1);

    if (copyPolygons(obj.modCore(), op2.core())) {
        op2.update();
        list.push(op2);
    } else {
        op2.owner().removeChild(op2);
    }

    doc.root().addChildAtIndex(cutMod, doc.root().childCount()-1);

    return list;
}

function crack( tool ) {
    random_seed = tool.getParameter("random seed");
    Math.seedrandom( random_seed );
    
    var redrawLock = true; // do redraw lock

    var doc = tool.document();
    var objBase = doc.selectedObject();
    
    var iter = 24;

    var pieces = tool.getParameter("pieces");
    var keep = tool.getParameter("keep original");
    var group = true; //tool.getParameter("make group");
    var copyMaterial = tool.getParameter("copy material tags");
    var burnPivot = tool.getParameter("burn pivot");

    var crackType = tool.getParameter("crack type");
    
    var crackSize = tool.getParameter("crack size var.");
    var crackAngle = tool.getParameter("crack angle var.");

    var crackPoint = tool.getParameter("crack point");
    var crackWeight = tool.getParameter("crack weight");
    var crackWeightCurve = tool.getParameter("crack weight curve");

    var crackMinSize = tool.getParameter("crack min size");

    var crackSize_h = crackSize / 2;

    print('-- Cracker.js');

    if (!objBase || objBase.family() != NGONFAMILY) {
        OS.beep(); return;
    }
    
    if (redrawLock) doc.retainRedrawLock();

    // detect cage

    var maxSize = sizeMax( objBase, 2 );
    var boundingBox = getBoundingBox( objBase );

    if (boundingBox === null) return;

    //

    var objName = objBase.getParameter("name");
    
    //

    crackPoint = objBase.obj2WorldMatrix().inverse().multiply( crackPoint );

    //

    cutVertices = [
                    new Vec3D(-maxSize, 0, -maxSize),
                    new Vec3D(-maxSize, 0,  maxSize),
                    new Vec3D( maxSize, 0,  maxSize),
                    new Vec3D( maxSize, 0, -maxSize),
                    new Vec3D(-maxSize, maxSize, -maxSize),
                    new Vec3D( maxSize, maxSize, -maxSize),
                    new Vec3D( maxSize, maxSize,  maxSize),
                    new Vec3D(-maxSize, maxSize,  maxSize)
                   ];

    cutIndices = [
                    [0, 1, 2, 3],
                    [4, 5, 6, 7],
                    [4, 7, 1, 0],
                    [7, 6, 2, 1],
                    [6, 5, 3, 2],
                    [5, 4, 0, 3]
                   ];

    //

    var objMatInverse = new Mat4D();

    var initObj = doc.addObject(POLYGONOBJ);
    copyPolygons( objBase.modCore(), initObj.core() );
    initObj.update();

    var i, j, len, c, obj;
    var list = [initObj];
    var listKeep = [];
    var listKeepLengthBefore = 0;

    var pos = new Vec3D();
    var rot = new Vec3D();

    var stopCrack = false;
    for (i = 0;i < iter;i++) {
        //print('--');
        print( 'iteration: ' + (i+1) );

        if (crackType == 0 || crackType == 2) {
            var range = 90 + crackAngle * 90;
        } else {
            var range = 180 * crackAngle;
        }

        print( range );

        len = list.length;
        var newList = [];
        for (j = 0;j < len;j++) {
            obj = list[j];

            boundingBox = getBoundingBox(obj);
            var bbMin = boundingBox[0];
            var bbMax = boundingBox[1];

            var sx = 0.5;
            var sy = 0.5;
            var sz = 0.5;

            if (crackSize > 0) {
                sx += crackSize_h - Math.random() * crackSize;
                sy += crackSize_h - Math.random() * crackSize;
                sz += crackSize_h - Math.random() * crackSize;
            }

            switch(crackType) {
                case 0:
                    pos.x = bbMin.x + sx * (bbMax.x - bbMin.x);
                    pos.y = bbMin.y + sy * (bbMax.y - bbMin.y);
                    pos.z = bbMin.z + sz * (bbMax.z - bbMin.z);

                    rot.x = Math.random()*360;
                    rot.y = range/2 - Math.random()*range;
                    rot.z = 0;
                    break;
                case 1:
                    pos.x = bbMin.x + sx * (bbMax.x - bbMin.x);
                    pos.y = bbMin.y + sy * (bbMax.y - bbMin.y);
                    pos.z = bbMin.z + sz * (bbMax.z - bbMin.z);

                    var p = i % 3;
                    rot.x = 0;
                    rot.y = 0;
                    rot.z = 0;
                    if (p == 1) {
                        rot.y = 90 + (range/2 - Math.random() * range);
                    } else if (p == 2) {
                        rot.z = 90 + (range/2 - Math.random() * range);
                    }
                    break;
                case 2:
                    pos = crackPoint.copy();

                    rot.x = Math.random()*360;
                    rot.y = range/2 - Math.random()*range;
                    rot.z = 0;
                    break;
                case 3:
                    pos.x = bbMin.x + sx * (bbMax.x - bbMin.x);
                    pos.y = bbMin.y + sy * (bbMax.y - bbMin.y);
                    pos.z = bbMin.z + sz * (bbMax.z - bbMin.z);

                    /*
                    rot.x = Math.random()*360;
                    rot.y = range/2 - Math.random()*range;
                    rot.z = 0;
                     */

                    var p = i % 3;
                    rot.x = 0;
                    rot.y = 0;
                    rot.z = 0;
                    if (p == 1) {
                        rot.y = 90 + (range/2 - Math.random() * range);
                    } else if (p == 2) {
                        rot.z = 90 + (range/2 - Math.random() * range);
                    }

                    //print( p + ':' + Vec3D_toString(rot) );

                    break;
            }

            var objs = cutPolygonObject( doc, obj, pos, rot, objMatInverse );

            if (objs.length < 2) {
                //print('cut error');

                /*
                var cutBack = doc.addObject(POLYGONOBJ);
                copyPolygons( cutObj.core(), cutBack.core() );
                cutBack.update();

                stopCrack = true;
                break;
                 */
            }

            for(var oi = 0;oi < objs.length;oi++) {
                newList.push( objs[oi] );
            }

            if ((len - (j+1)) + newList.length + listKeep.length >= pieces) {
                if (i > 0) {
                    for(k = 0;k < j+1;k++) {
                        //print( 'remove:' + k );
                        list[k].owner().removeChild( list[k] );
                    }
                }

                for (k = j+1;k < len;k++) {
                    //print( 'add:' + k );
                    newList.push( list[k] );
                }
                
                //print('stop crack');
                stopCrack = true;
                
                break;
            }
        }

        if (stopCrack === false) {
            var listLen = list.length;
            for (j = listLen - 1;j > -1;j--) {
                c = list.pop();
                c.owner().removeChild(c);
                c = null;
            }
        }

        list = newList;

        //

        if (stopCrack == false) {
            len = list.length;

            var listKeepTmp = [];
            var listReorder = [];

            //print( 'weight:' + ( crackWeight.toFixed(3) ) );
            //print( 'crack point:' + Vec3D_toString( crackPoint ) );

            var sizeMin = 0;

            if (crackType == 3) {

                for (j = 0;j < len;j++) {
                    var obj = list[j];

                    var l = getDistanceTo( obj, crackPoint );
                    var s = getVolume( obj );

                    /*
                    if (l !== undefined) {
                        print( j + ':' + l.toFixed(3) + ', ' + s.toFixed(3) + ' / ' + crackMinSize.toFixed(3) );
                    } else {
                        print( j + ':' + l + ', ' + s.toFixed(3) + ' / ' + crackMinSize.toFixed(3) );
                    }
                     */

                    if (s <= crackMinSize) {
                        sizeMin++;
                        listKeepTmp.push( obj );
                    } else {

                        if (l === undefined) {
                            listReorder.push( obj );
                        } else if (l <= crackWeight) {
                            listReorder.push( obj );
                        } else {
                            //print( j + ':keep, ' + l.toFixed(3) );
                            listKeepTmp.push( obj );
                        }
                    }
                }

            } else {

                for (j = 0;j < len;j++) {
                    var obj = list[j];

                    var s = getVolume( obj );

                    //print( j + ':' + s.toFixed(3) + ' / ' + crackMinSize.toFixed(3) );

                    if (s <= crackMinSize) {
                        sizeMin++;
                        listKeepTmp.push( obj );
                    } else {
                        listReorder.push( obj );
                    }
                }
            }

            if (listReorder.length > 0) {
                crackWeight *= crackWeightCurve;

                list = listReorder;

                for (j = listKeepTmp.length;j > 0;j--) {
                    listKeep.push( listKeepTmp.pop() );
                }

            } else {

                //print( i + ': no detect' );

                if (sizeMin == list.length) {
                    print( 'force stop: size of all pieces are small.' );
                    stopCrack = true;
                }

            }

            print( 'list: ' + list.length + ', keep: ' + listKeep.length );
        }
        
        //
        if (stopCrack === true) {
            i = iter;
        }
    }

    // merge pieces
    len = listKeep.length;
    for (i = len - 1;i > -1;i--) {
        var keepObj = listKeep.pop();
        list.push( keepObj );
    }
    //print( 'list: ' + list.length );

    if (group) {
        var folder = doc.addObject(FOLDER);
        doc.root().addChildAtIndex(folder, doc.root().childCount()-1);

        len = list.length;
        for (i = 0;i < len;i++) {
            c = list[i];
            folder.addChildAtIndex(c, i);
            c.setParameter("name", objName + '_' + i);
            centerPivot(c, burnPivot);
            
            copyParameters(objBase, c, ["normalType", "normalAngle", "displayType", "displayGhosted"]);
        }

        folder.setParameter("name", objName + '_cracked');
        copyParameters(objBase, folder, ["position", "rotation", "scale"]);
        
        objBase.owner().addChildAtIndex( folder, objBase.owner().childCount - 1 );
    }

    if (copyMaterial) {
        var baseMatTagList = [];
        var tag, tagCount = objBase.tagCount();

        for (i = 0;i < tagCount;i++) {
            tag = objBase.tagAtIndex(i);

            if (tag.type() == SHADERTAG) {
                baseMatTagList.push( tag );
            }
        }

        len = list.length;
        for (i = 0;i < len;i++) {
            c = list[i];
            for (j = 0;j < baseMatTagList.length;j++) {
                tag = c.addTagOfType(SHADERTAG);

                copyParameters(baseMatTagList[j], tag, ["locked", "tagOn", "priority", "material", 
                                    "shadeSelection", "shadingSpace", "tangentSpace", "shadingRotation", 
                                    "shadingScale", "shadingOffset", "UVRotation", "UVScale", "UVOffset" ]);
            }

            c.update();
        }

    }

    if (!keep) {
        objBase.owner().removeChild(objBase);
    }

    // delete obj

    if (cutObj !== null) {
        cutObj.owner().removeChild( cutObj );
        cutObj = null;
    }
    if (cutMod !== null) {
        cutMod.owner().removeChild( cutMod );
        cutMod = null;
    }

    if (redrawLock) {
        doc.releaseRedrawLock();
        doc.redrawAll();
    }

}

function copyParameters(from, to, params) {
    for (var i in params) {
        to.setParameter(params[i], from.getParameter(params[i]));
    }
}

function copyPolygons(from, to) {

    var vertexCount = from.vertexCount();

    for (i = 0;i < vertexCount;i++) {
        to.addVertex(false, from.vertex(i));
    }

    var polygonCount = from.polygonCount();

    for (i = 0;i < polygonCount;i++) {
        var polygonSize = from.polygonSize(i);
        var verts = [];
        var uvs = [];
        for (j = 0;j < polygonSize;j++) {
            verts.push( from.vertexIndex(i, j) );
            uvs.push( from.uvCoord(i, j) );
        }

        to.addIndexPolygon(polygonSize, verts, uvs);
    }

    return (vertexCount > 0)? true : false;
}

function centerPivot(obj, burn) {
    var core = obj.core();
    var vertexCount = core.vertexCount();

    var centerVec = null;
    for (i = 0;i < vertexCount;i++) {
        if (i === 0) {
            centerVec = core.vertex(i);
        } else {
            centerVec = centerVec.add( core.vertex(i) );
        }
    }

    if (centerVec === null) {
        //print('centerPivot: null error.');
        return;
    }

    centerVec = centerVec.multiply( 1 / vertexCount );

    if (burn) {

        for (i = 0;i < vertexCount;i++) {
            core.setVertex( i, core.vertex(i).sub(centerVec) );
        }

        obj.setParameter("position", obj.getParameter("position").add(centerVec));

    } else {

        obj.setParameter("pivot", obj.getParameter("position").add(centerVec));

    }
}

function sizeMax(obj, margin) {
    var sizeMax = 1;

    var core = obj.modCore();
    var mat = obj.obj2WorldMatrix();
    var vertexCount = core.vertexCount();

    for (i = 0;i < vertexCount;i++) {
        var vec = mat.multiply( core.vertex(i) );

        if (Math.abs(vec.x) > sizeMax) sizeMax = Math.abs(vec.x);
        if (Math.abs(vec.y) > sizeMax) sizeMax = Math.abs(vec.y);
        if (Math.abs(vec.z) > sizeMax) sizeMax = Math.abs(vec.z);
    }

    return sizeMax + margin;
}

function getDistanceTo( obj, point ) {
    var bb = getBoundingBox( obj );
    var cp = bb[0].add( bb[1] ).multiply( 0.5 );

    if (bb[0].x <= point.x && bb[0].y <= point.y && bb[0].z <= point.z &&
        bb[1].x >= point.x && bb[1].y >= point.y && bb[1].z >= point.z) {
        // point is inside bounding box
        return undefined;
    }

    var core = obj.core();

    var vertexCount = core.vertexCount();
    var polygonCount = core.polygonCount();
    var distMin = Vec3D_distance( cp, point );

    for(var i = 0;i < vertexCount;i++) {
        var v = core.vertex( i );
        var d = Vec3D_distance( point, v );

        if (distMin > d) {
            distMin = d;
        }
    }
    for(var i = 0;i < polygonCount;i++) {
        var size = core.polygonSize(i);
        var v = core.vertex( core.vertexIndex(i, 0) );
        for (var j = 1;j < size;j++) {
            v = v.add( core.vertex( core.vertexIndex(i, j) ) );
        }
        v.multiply( 1 / size );

        var d = Vec3D_distance( point, v );

        if (distMin > d) {
            distMin = d;
        }
    }

    return distMin;
}

function getVolume( obj ) {
    var bb = getBoundingBox( obj );

    return Vec3D_distance( bb[0], bb[1] );
}

function getBoundingBox(obj) {
    var core = obj.modCore();
    //var mat = obj.obj2WorldMatrix();
    var vertexCount = core.vertexCount();

    if (vertexCount === 0) return null;

    var vecMin = core.vertex(0); //mat.multiply(core.vertex(0));
    var vecMax = core.vertex(0); //mat.multiply(core.vertex(0));

    for (var i = 1;i < vertexCount;i++) {
        var vec = core.vertex(i); //mat.multiply( core.vertex(i) );
        vecMin.x = Math.min(vecMin.x, vec.x);
        vecMin.y = Math.min(vecMin.y, vec.y);
        vecMin.z = Math.min(vecMin.z, vec.z);
        vecMax.x = Math.max(vecMax.x, vec.x);
        vecMax.y = Math.max(vecMax.y, vec.y);
        vecMax.z = Math.max(vecMax.z, vec.z);
    }

    return [ vecMin, vecMax ];
}

var Vec3D_distance = function() {
    if( arguments.length == 1)
            return Math.sqrt( arguments[0].x*arguments[0].x + arguments[0].y*arguments[0].y + arguments[0].z*arguments[0].z );
    var p = arguments[1].sub(arguments[0]);
    return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
};

var Vec3D_normalize = function(vec) {
    var l = vec.norm();
    if (l !== 0) {
        return vec.multiply( 1/l );
    }
    return vec;
};

var Vec3D_toString = function(vec) {
    return vec.x.toFixed(3) + ',' + vec.y.toFixed(3) + ',' + vec.z.toFixed(3);
};

// seeded random

/**
 * All code is in an anonymous closure to keep the global namespace clean.
 */
(function (
    global, pool, math, width, chunks, digits, module, define, rngname) {

//
// The following constants are related to IEEE 754 limits.
//
var startdenom = math.pow(width, chunks),
    significance = math.pow(2, digits),
    overflow = significance * 2,
    mask = width - 1,

//
// seedrandom()
// This is the seedrandom function described above.
//
impl = math['seed' + rngname] = function(seed, options, callback) {
  var key = [];
  options = (options == true) ? { entropy: true } : (options || {});

  // Flatten the seed string or build one from local entropy if needed.
  var shortseed = mixkey(flatten(
    options.entropy ? [seed, tostring(pool)] :
    (seed == null) ? autoseed() : seed, 3), key);

  // Use the seed to initialize an ARC4 generator.
  var arc4 = new ARC4(key);

  // Mix the randomness into accumulated entropy.
  mixkey(tostring(arc4.S), pool);

  // Calling convention: what to return as a function of prng, seed, is_math.
  return (options.pass || callback ||
      // If called as a method of Math (Math.seedrandom()), mutate Math.random
      // because that is how seedrandom.js has worked since v1.0.  Otherwise,
      // it is a newer calling convention, so return the prng directly.
      function(prng, seed, is_math_call) {
        if (is_math_call) { math[rngname] = prng; return seed; }
        else return prng;
      })(

  // This function returns a random double in [0, 1) that contains
  // randomness in every bit of the mantissa of the IEEE 754 value.
  function() {
    var n = arc4.g(chunks),             // Start with a numerator n < 2 ^ 48
        d = startdenom,                 //   and denominator d = 2 ^ 48.
        x = 0;                          //   and no 'extra last byte'.
    while (n < significance) {          // Fill up all significant digits by
      n = (n + x) * width;              //   shifting numerator and
      d *= width;                       //   denominator and generating a
      x = arc4.g(1);                    //   new least-significant-byte.
    }
    while (n >= overflow) {             // To avoid rounding up, before adding
      n /= 2;                           //   last byte, shift everything
      d /= 2;                           //   right using integer math until
      x >>>= 1;                         //   we have exactly the desired bits.
    }
    return (n + x) / d;                 // Form the number within [0, 1).
  }, shortseed, 'global' in options ? options.global : (this == math));
};

//
// ARC4
//
// An ARC4 implementation.  The constructor takes a key in the form of
// an array of at most (width) integers that should be 0 <= x < (width).
//
// The g(count) method returns a pseudorandom integer that concatenates
// the next (count) outputs from ARC4.  Its return value is a number x
// that is in the range 0 <= x < (width ^ count).
//
/** @constructor */
function ARC4(key) {
  var t, keylen = key.length,
      me = this, i = 0, j = me.i = me.j = 0, s = me.S = [];

  // The empty key [] is treated as [0].
  if (!keylen) { key = [keylen++]; }

  // Set up S using the standard key scheduling algorithm.
  while (i < width) {
    s[i] = i++;
  }
  for (i = 0; i < width; i++) {
    s[i] = s[j = mask & (j + key[i % keylen] + (t = s[i]))];
    s[j] = t;
  }

  // The "g" method returns the next (count) outputs as one number.
  (me.g = function(count) {
    // Using instance members instead of closure state nearly doubles speed.
    var t, r = 0,
        i = me.i, j = me.j, s = me.S;
    while (count--) {
      t = s[i = mask & (i + 1)];
      r = r * width + s[mask & ((s[i] = s[j = mask & (j + t)]) + (s[j] = t))];
    }
    me.i = i; me.j = j;
    return r;
    // For robust unpredictability discard an initial batch of values.
    // See http://www.rsa.com/rsalabs/node.asp?id=2009
  })(width);
}

//
// flatten()
// Converts an object tree to nested arrays of strings.
//
function flatten(obj, depth) {
  var result = [], typ = (typeof obj), prop;
  if (depth && typ == 'object') {
    for (prop in obj) {
      try { result.push(flatten(obj[prop], depth - 1)); } catch (e) {}
    }
  }
  return (result.length ? result : typ == 'string' ? obj : obj + '\0');
}

//
// mixkey()
// Mixes a string seed into a key that is an array of integers, and
// returns a shortened string seed that is equivalent to the result key.
//
function mixkey(seed, key) {
  var stringseed = seed + '', smear, j = 0;
  while (j < stringseed.length) {
    key[mask & j] =
      mask & ((smear ^= key[mask & j] * 19) + stringseed.charCodeAt(j++));
  }
  return tostring(key);
}

//
// autoseed()
// Returns an object for autoseeding, using window.crypto if available.
//
/** @param {Uint8Array|Navigator=} seed */
function autoseed(seed) {
  try {
    global.crypto.getRandomValues(seed = new Uint8Array(width));
    return tostring(seed);
  } catch (e) {
    return [+new Date, global, (seed = global.navigator) && seed.plugins,
            global.screen, tostring(pool)];
  }
}

//
// tostring()
// Converts an array of charcodes to a string
//
function tostring(a) {
  return String.fromCharCode.apply(0, a);
}

//
// When seedrandom.js is loaded, we immediately mix a few bits
// from the built-in RNG into the entropy pool.  Because we do
// not want to intefere with determinstic PRNG state later,
// seedrandom will not call math.random on its own again after
// initialization.
//
mixkey(math[rngname](), pool);

//
// Nodejs and AMD support: export the implemenation as a module using
// either convention.
//
if (module && module.exports) {
  module.exports = impl;
} else if (define && define.amd) {
  define(function() { return impl; });
}

// End anonymous scope, and pass initial values.
})(
  this,   // global window object
  [],     // pool: entropy pool starts empty
  Math,   // math: package containing random, pow, and seedrandom
  256,    // width: each RC4 output is 0 <= x < 256
  6,      // chunks: at least six RC4 outputs for each double
  52,     // digits: there are 52 significant digits in a double
  (typeof module) == 'object' && module,    // present in node.js
  (typeof define) == 'function' && define,  // present with an AMD loader
  'random'// rngname: name for Math.random and Math.seedrandom
);

