// Particle2Polygon.js
//
// v.20141210
//

var Vec3D_toString = function(vec) {
    return vec.x.toFixed(3) + ' ' + vec.y.toFixed(3) + ' ' + vec.z.toFixed(3);
}

function buildUI(tool) {

    tool.addParameterSeparator("Particle 2 Polygon");

    tool.addParameterButton("convert","convert","convertParticle");

}

var vertexIndex = 0;
var polyIndex = 0;

function convertParticle(tool) {

    var i, j, k;
    var doc = tool.document();
    var particle = doc.selectedObject();
    
    if (particle && particle.family() != PARTICLEFAMILY) return;

    var particleCore = particle.core();

    var obj = doc.addObject( POLYGONOBJ );
    doc.root().addChildAtIndex( obj, doc.root().childCount() );

    obj.setParameter("name", particle.getParameter("name") + '_polygon');

    var core = obj.core();

    var children = [];

    var childCount = particle.childCount();
    var matTag_vars = ["locked", "position", "scale", "shear", "rotation", "tagOn", "priority", "material", "shadingSpace", "tangentSpace", "shadingRotation", "shadingScale", "shadingOffset", "UVRotation", "UVScale", "UVOffset", "tileU", "tileV"];

    var matTag_index = 0;

    for (i = 0;i < childCount;i++) {
        var child = particle.childAtIndex( i );

        var matTags = [];
        var matTag_info = [];

        var tagCount = child.tagCount();
        for (j = 0;j < tagCount;j++) {
            var tag = child.tagAtIndex( j );

            if (tag.type() == SHADERTAG) {
                var matTag = tag;
                matTags.push( matTag );
            }

        }

        if (matTags.length > 0) {

            for (k = 0;k < matTags.length;k++) {
                var matTag = obj.addTagOfType( SHADERTAG );
                var selIndex = i + 2 + k + matTag_index;

                if (selIndex < 17) {

                    var selIndex_copy = matTags[k].getParameter("shadeSelection");

                    matTag.setParameter("shadeSelection", selIndex);

                    for (j = 0;j < matTag_vars.length;j++) {
                        matTag.setParameter(matTag_vars[j], matTags[k].getParameter(matTag_vars[j]));
                    }

                    matTag_info.push( [ selIndex_copy - 1, i + 1 + k + matTag_index ] ); // original sel -> new sel

                }
            }
        }

        if (matTag_info.length == 0) {
            matTag_info.push( [ -1, i + 1 + matTag_index ] );
        }

        if (child.family() == NGONFAMILY) {
            var childCore = child.modCore();
        } else {
            var childCore = undefined;
        }

        children.push( { "obj" : child, "modCore" : childCore, "matrix" : child.objMatrix(), "matInfo" : matTag_info } );

        matTag_index += matTags.length - 1;
    }

    vertexIndex = 0;
    polyIndex = 0;

    var particleCount = particleCore.particleCount();

    for (i = 0;i < particleCount;i++) {

        var p = particleCore.particleAtIndex( i );

        var childIndex = p.getIndex();

        var copyChild = children[ childIndex ];

        var position = p.getPosition();
        var rotation = p.getRotation();
        var scale = p.getScale();

        var mat_pos = new Mat4D( TRANSLATE, position.x, position.y, position.z );
        var mat_rot = new Mat4D( ROTATE, rotation.x, rotation.y, rotation.z );
        var mat_scale = new Mat4D( SCALE, scale.x, scale.y, scale.z );

        var matrix = mat_pos.multiply( mat_rot.multiply( mat_scale.multiply( copyChild.matrix ) ) );

        CopyCore( core, copyChild.modCore, matrix, childIndex, copyChild.matInfo );
    }

    obj.setParameter("position", particle.getParameter("position"));
    obj.setParameter("rotation", particle.getParameter("rotation"));
    obj.setParameter("scale", particle.getParameter("scale"));

    obj.update();

}

Array.prototype.toString = function() {
    var str = "(";
    for (var i = 0;i < this.length;i++) {
        if (i == 0) str += this[i];
        else        str += ", " + this[i]; 
    }
    str += ")";
    return str;
}

function CopyCore( core, copyCore, matrix, childIndex, matInfo ) {

    if (copyCore == undefined) return;

    var i, j;
    var polyCount = copyCore.polygonCount();
    var vertexCount = copyCore.vertexCount();

    for (i = 0;i < vertexCount;i++) {
        var vertex = matrix.multiply( copyCore.vertex(i) );
        core.addVertex( false, vertex );
    }

    for (i = 0;i < polyCount;i++) {
        var size = copyCore.polygonSize( i );
        var verts = new Array();
        var uvs = new Array();

        for (j = 0;j < size;j++) {
            verts[j] = copyCore.vertexIndex( i, j ) + vertexIndex;
            var uv = copyCore.uvCoord( i, j );
            uvs[j] = new Vec2D( uv.x, uv.y );
        }
        core.addIndexPolygon( size, verts, uvs );
    }

    for (i = 0;i < matInfo.length;i++) {
        var polySel = matInfo[i][1];
        var polySel_copy = matInfo[i][0];

        if (polySel < 16) {

            core.setActivePolygonSelection( polySel );
            if (polySel_copy > -1) copyCore.setActivePolygonSelection( polySel_copy );

            for (j = 0;j < polyCount;j++) {
                if (polySel_copy == -1) { // all
                    core.setPolygonSelection( j + polyIndex, true );
                } else {
                    if (copyCore.polygonSelection( j )) {
                        core.setPolygonSelection( j + polyIndex, true );
                    }
                }
            }
        }
    }

    core.setActivePolygonSelection( 0 );
    copyCore.setActivePolygonSelection( 0 );

    polyIndex += polyCount;
    vertexIndex += vertexCount;
}


